/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;

@Component
@Singleton
public class DefaultExtensionManager
implements ExtensionManager,
Initializable {
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    private Map<String, ExtensionRepository> standardRepositories = new HashMap<String, ExtensionRepository>(3);

    public void initialize() throws InitializationException {
        this.standardRepositories.put(this.coreExtensionRepository.getDescriptor().getId(), this.coreExtensionRepository);
        this.standardRepositories.put(this.localExtensionRepository.getDescriptor().getId(), this.localExtensionRepository);
        this.standardRepositories.put(this.installedExtensionRepository.getDescriptor().getId(), this.installedExtensionRepository);
    }

    @Override
    public Extension resolveExtension(ExtensionId extensionId) throws ResolveException {
        try {
            return this.coreExtensionRepository.resolve(extensionId);
        }
        catch (ResolveException notACoreExtension) {
            return this.resolveExtensionFromInstalled(extensionId);
        }
    }

    private Extension resolveExtensionFromInstalled(ExtensionId extensionId) throws ResolveException {
        try {
            return this.installedExtensionRepository.resolve(extensionId);
        }
        catch (ResolveException notAnInstalledExtension) {
            try {
                return this.localExtensionRepository.resolve(extensionId);
            }
            catch (ResolveException notALocalExtension) {
                return this.repositoryManager.resolve(extensionId);
            }
        }
    }

    @Override
    public Extension resolveExtension(ExtensionDependency extensionDependency) throws ResolveException {
        try {
            return this.coreExtensionRepository.resolve(extensionDependency);
        }
        catch (ResolveException notACoreExtension) {
            return this.resolveExtensionFromInstalled(extensionDependency);
        }
    }

    private Extension resolveExtensionFromInstalled(ExtensionDependency extensionDependency) throws ResolveException {
        try {
            return this.installedExtensionRepository.resolve(extensionDependency);
        }
        catch (ResolveException notAnInstalledExtension) {
            try {
                return this.localExtensionRepository.resolve(extensionDependency);
            }
            catch (ResolveException notALocalExtension) {
                return this.repositoryManager.resolve(extensionDependency);
            }
        }
    }

    @Override
    public ExtensionRepository getRepository(String repositoryId) {
        ExtensionRepository repository = this.standardRepositories.get(repositoryId);
        if (repository == null) {
            repository = this.repositoryManager.getRepository(repositoryId);
        }
        return repository;
    }
}

