/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;

@Component
@Named(value="install")
public class InstallJob
extends AbstractExtensionJob<InstallRequest, DefaultJobStatus<InstallRequest>> {
    public static final String JOBTYPE = "install";
    @Inject
    @Named(value="installplan")
    private Job installPlanJob;
    @Inject
    private Execution execution;

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        this.notifyPushLevelProgress(3);
        ExecutionContext context = this.execution.getContext();
        try {
            InstallRequest planRequest = new InstallRequest(this.getRequest());
            planRequest.setId(null);
            this.installPlanJob.start((Request)planRequest);
            ExtensionPlan plan = (ExtensionPlan)this.installPlanJob.getStatus();
            List log = plan.getLog().getLogs(LogLevel.ERROR);
            if (!log.isEmpty()) {
                throw new InstallException("Failed to create install plan: " + ((LogEvent)log.get(0)).getFormattedMessage(), ((LogEvent)log.get(0)).getThrowable());
            }
            this.notifyStepPropress();
            context.setProperty("job.extension.plan", (Object)plan);
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.notifyPushLevelProgress(actions.size());
            try {
                for (ExtensionPlanAction action : actions) {
                    this.store(action);
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
            this.notifyStepPropress();
            this.applyActions(actions);
        }
        finally {
            this.notifyPopLevelProgress();
            context.removeProperty("job.extension.plan");
        }
    }

    private void store(ExtensionPlanAction action) throws LocalExtensionRepositoryException {
        if (action.getAction() == ExtensionPlanAction.Action.INSTALL || action.getAction() == ExtensionPlanAction.Action.UPGRADE || action.getAction() == ExtensionPlanAction.Action.DOWNGRADE) {
            this.storeExtension(action.getExtension());
        }
    }

    private void storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        if (!this.localExtensionRepository.exists(extension.getId())) {
            this.logger.info("Downloading [{}]", (Object)extension.getId());
            this.localExtensionRepository.storeExtension(extension);
        }
    }
}

