/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.internal.installed.DefaultInstalledExtension;
import org.xwiki.extension.repository.internal.local.AbstractCachedExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;

@Component
@Singleton
public class DefaultInstalledExtensionRepository
extends AbstractCachedExtensionRepository<DefaultInstalledExtension>
implements InstalledExtensionRepository,
Initializable {
    @Inject
    private transient LocalExtensionRepository localRepository;
    @Inject
    private transient CoreExtensionRepository coreExtensionRepository;
    @Inject
    private transient Logger logger;
    private Map<String, Map<String, InstalledFeature>> extensionNamespaceByFeature = new ConcurrentHashMap<String, Map<String, InstalledFeature>>();

    public void initialize() throws InitializationException {
        this.setDescriptor(new DefaultExtensionRepositoryDescriptor("installed", "installed", this.localRepository.getDescriptor().getURI()));
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!DefaultInstalledExtension.isInstalled(localExtension)) continue;
            this.validateExtension(localExtension);
        }
    }

    private void validateExtension(LocalExtension localExtension) {
        Collection<String> namespaces = DefaultInstalledExtension.getNamespaces(localExtension);
        if (namespaces == null) {
            try {
                this.validateExtension(localExtension, null);
            }
            catch (InvalidExtensionException e) {
                this.logger.error("Invalid extension [{}] it will not be loaded", (Object)localExtension.getId(), (Object)e);
                this.addInstalledExtension(localExtension, null, false);
            }
        } else {
            for (String namespace : namespaces) {
                try {
                    this.validateExtension(localExtension, namespace);
                }
                catch (InvalidExtensionException e) {
                    this.logger.error("Invalid extension [{}] on namespace [], it will not be loaded", new Object[]{localExtension.getId(), namespace, e});
                    this.addInstalledExtension(localExtension, namespace, false);
                }
            }
        }
    }

    private void validateExtension(LocalExtension localExtension, String namespace) throws InvalidExtensionException {
        InstalledFeature feature = this.getInstalledFeatureFromCache(localExtension.getId().getId(), namespace);
        if (feature != null && StringUtils.equals((CharSequence)feature.namespace, (CharSequence)"namespace")) {
            return;
        }
        if (namespace != null && DefaultInstalledExtension.getNamespaces(localExtension) == null) {
            this.validateExtension(localExtension, null);
            return;
        }
        if (!DefaultInstalledExtension.isInstalled(localExtension, namespace)) {
            throw new InvalidExtensionException("Extension [" + localExtension + "] is not installed");
        }
        if (this.coreExtensionRepository.exists(localExtension.getId().getId())) {
            throw new InvalidExtensionException("Extension [" + localExtension + "] already exists as a core extension");
        }
        for (ExtensionDependency extensionDependency : localExtension.getDependencies()) {
            CoreExtension coreExtension = this.coreExtensionRepository.getCoreExtension(extensionDependency.getId());
            if (coreExtension != null) {
                if (this.isCompatible(coreExtension.getId().getVersion(), extensionDependency.getVersionConstraint())) continue;
                throw new InvalidExtensionException("Extension [" + localExtension + "] is incompatible with the core extension [" + coreExtension + "]");
            }
            boolean valid = false;
            Collection<LocalExtension> dependencyVersionsCollection = this.localRepository.getLocalExtensionVersions(extensionDependency.getId());
            if (!dependencyVersionsCollection.isEmpty()) {
                ArrayList<LocalExtension> dependencyVersions = new ArrayList<LocalExtension>(dependencyVersionsCollection);
                Collections.reverse(dependencyVersions);
                for (LocalExtension dependencyVersion : dependencyVersions) {
                    if (!this.isCompatible(dependencyVersion.getId().getVersion(), extensionDependency.getVersionConstraint())) continue;
                    try {
                        this.validateExtension(dependencyVersion, namespace);
                        valid = true;
                        break;
                    }
                    catch (InvalidExtensionException e) {
                    }
                }
            }
            if (valid) continue;
            throw new InvalidExtensionException("The dependency [" + extensionDependency + "] of extension [" + localExtension + "] is invalid");
        }
        this.addInstalledExtension(localExtension, namespace, true);
    }

    private boolean isCompatible(Version existingVersion, VersionConstraint versionConstraint) {
        boolean compatible = true;
        compatible = versionConstraint.getVersion() == null ? versionConstraint.containsVersion(existingVersion) : existingVersion.compareTo(versionConstraint.getVersion()) >= 0;
        return compatible;
    }

    private void removeInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) throws UninstallException {
        this.removeInstalledFeature(installedExtension.getId().getId(), namespace);
        for (String feature : installedExtension.getFeatures()) {
            this.removeInstalledFeature(feature, namespace);
        }
        this.removeFromBackwardDependencies(installedExtension, namespace);
        if (!installedExtension.isInstalled()) {
            this.removeCachedExtension(installedExtension);
        }
    }

    private void removeInstalledFeature(String feature, String namespace) throws UninstallException {
        if (namespace == null) {
            this.extensionNamespaceByFeature.remove(feature);
        } else {
            Map<String, InstalledFeature> namespaceInstalledExtension = this.extensionNamespaceByFeature.get(feature);
            namespaceInstalledExtension.remove(namespace);
        }
    }

    private void applyInstallExtension(DefaultInstalledExtension installedExtension, String namespace) throws InstallException {
        installedExtension.setInstalled(true, namespace);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new InstallException("Failed to modify extension descriptor", e);
        }
        this.addInstalledExtension(installedExtension, namespace, true);
    }

    private void removeFromBackwardDependencies(DefaultInstalledExtension installedExtension, String namespace) {
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            if (this.coreExtensionRepository.getCoreExtension(dependency.getId()) != null) continue;
            InstalledFeature installedFeature = this.getInstalledFeatureFromCache(dependency.getId(), namespace);
            if (installedFeature == null) {
                this.logger.warn("Extension [{}] is not installed", (Object)installedExtension.getId());
                continue;
            }
            if (installedFeature.backwardDependencies.remove(installedExtension)) continue;
            this.logger.warn("Extension [{}] was not regisistered as backward dependency of [{}]", (Object)installedExtension.getId(), (Object)installedFeature.extension.getId());
        }
    }

    private void addInstalledExtension(LocalExtension localExtension, String namespace, boolean valid) {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.extensions.get(localExtension.getId());
        if (installedExtension == null) {
            installedExtension = new DefaultInstalledExtension(localExtension, this);
        }
        installedExtension.setInstalled(true, namespace);
        installedExtension.setValid(namespace, valid);
        this.addInstalledExtension(installedExtension, namespace);
    }

    private void addInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) {
        this.addCachedExtension(installedExtension);
        this.addInstalledFeatureToCache(installedExtension.getId().getId(), namespace, installedExtension);
        for (String feature : installedExtension.getFeatures()) {
            this.addInstalledFeatureToCache(feature, namespace, installedExtension);
        }
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            if (this.coreExtensionRepository.exists(dependency.getId())) continue;
            DefaultInstalledExtension dependencyLocalExtension = (DefaultInstalledExtension)this.getInstalledExtension(dependency.getId(), namespace);
            InstalledFeature dependencyInstalledExtension = this.addInstalledFeatureToCache(dependency.getId(), namespace, dependencyLocalExtension);
            dependencyInstalledExtension.backwardDependencies.add(installedExtension);
        }
    }

    private InstalledFeature addInstalledFeatureToCache(String feature, String namespace, DefaultInstalledExtension localExtension) {
        InstalledFeature installedExtension;
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsForFeature == null) {
            installedExtensionsForFeature = new HashMap<String, InstalledFeature>();
            this.extensionNamespaceByFeature.put(feature, installedExtensionsForFeature);
        }
        if ((installedExtension = installedExtensionsForFeature.get(namespace)) == null) {
            installedExtension = new InstalledFeature(localExtension, feature, namespace);
            installedExtensionsForFeature.put(namespace, installedExtension);
        }
        return installedExtension;
    }

    private InstalledFeature getInstalledFeatureFromCache(String feature, String namespace) {
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsForFeature == null) {
            return null;
        }
        InstalledFeature installedExtension = installedExtensionsForFeature.get(namespace);
        if (installedExtension == null && namespace != null) {
            installedExtension = this.getInstalledFeatureFromCache(feature, null);
        }
        return installedExtension;
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        ArrayList<InstalledExtension> result = new ArrayList<InstalledExtension>(this.extensions.size());
        for (DefaultInstalledExtension installedExtension : this.extensions.values()) {
            if (!installedExtension.isInstalled(namespace)) continue;
            result.add(installedExtension);
        }
        return result;
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public InstalledExtension getInstalledExtension(ExtensionId extensionId) {
        return (InstalledExtension)this.extensions.get(extensionId);
    }

    @Override
    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        InstalledFeature installedFeature = this.getInstalledFeatureFromCache(feature, namespace);
        if (installedFeature != null) {
            return installedFeature.extension;
        }
        return null;
    }

    @Override
    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.extensions.get(extension.getId());
        if (installedExtension != null && installedExtension.isInstalled(namespace)) {
            if (installedExtension.isDependency() == dependency) {
                throw new InstallException("The extension [" + installedExtension + "] is already installed on namespace [" + namespace + "]");
            }
            installedExtension.setDependency(dependency, namespace);
            try {
                this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
            }
            catch (Exception e) {
                throw new InstallException("Failed to modify extension descriptor", e);
            }
        } else {
            LocalExtension localExtension = this.localRepository.getLocalExtension(extension.getId());
            if (localExtension == null) {
                throw new InstallException("The extension [" + extension + "] need to be stored first");
            }
            if (installedExtension == null) {
                installedExtension = new DefaultInstalledExtension(localExtension, this);
            }
            if (dependency || installedExtension.getProperty("installed.dependency") == null) {
                installedExtension.setDependency(dependency, namespace);
            }
            this.applyInstallExtension(installedExtension, namespace);
        }
        return installedExtension;
    }

    @Override
    public void uninstallExtension(InstalledExtension extension, String namespace) throws UninstallException {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.getInstalledExtension(extension.getId().getId(), namespace);
        if (installedExtension != null) {
            this.applyUninstallExtension(installedExtension, namespace);
        }
    }

    private void applyUninstallExtension(DefaultInstalledExtension installedExtension, String namespace) throws UninstallException {
        installedExtension.setInstalled(false, namespace);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new UninstallException("Failed to modify extension descriptor", e);
        }
        this.removeInstalledExtension(installedExtension, namespace);
    }

    @Override
    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace) throws ResolveException {
        InstalledFeature installedExtension;
        if (this.getInstalledExtension(feature, namespace) == null) {
            throw new ResolveException("Extension [" + feature + "] is not installed on namespace [" + namespace + "]");
        }
        Map<String, InstalledFeature> installedExtensionsByFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsByFeature != null && (installedExtension = installedExtensionsByFeature.get(namespace)) != null) {
            Set<DefaultInstalledExtension> backwardDependencies = installedExtension.backwardDependencies;
            return backwardDependencies != null ? new ArrayList<DefaultInstalledExtension>(backwardDependencies) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        Map<String, Collection<InstalledExtension>> result;
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.resolve(extensionId);
        Collection<String> namespaces = installedExtension.getNamespaces();
        Map<String, InstalledFeature> featureExtensions = this.extensionNamespaceByFeature.get(installedExtension.getId().getId());
        if (featureExtensions != null) {
            result = new HashMap();
            for (InstalledFeature festureExtension : featureExtensions.values()) {
                if (namespaces != null && !namespaces.contains(festureExtension.namespace) || festureExtension.backwardDependencies.isEmpty()) continue;
                result.put(festureExtension.namespace, new ArrayList<DefaultInstalledExtension>(festureExtension.backwardDependencies));
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private static class InstalledFeature {
        public DefaultInstalledExtension extension;
        public String feature;
        public String namespace;
        public Set<DefaultInstalledExtension> backwardDependencies = new HashSet<DefaultInstalledExtension>();

        public InstalledFeature(DefaultInstalledExtension extension, String feature, String namespace) {
            this.extension = extension;
            this.feature = feature;
            this.namespace = namespace;
        }
    }
}

