/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;

@Component
@Named(value="install")
public class InstallJob
extends AbstractExtensionJob<InstallRequest> {
    public static final String JOBTYPE = "install";
    @Inject
    @Named(value="installplan")
    private Job installPlanJob;

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        this.notifyPushLevelProgress(3);
        try {
            InstallRequest planRequest = new InstallRequest(this.getRequest());
            planRequest.setId(null);
            this.installPlanJob.start((Request)planRequest);
            ExtensionPlan plan = (ExtensionPlan)this.installPlanJob.getStatus();
            List log = plan.getLog().getLogs(LogLevel.ERROR);
            if (!log.isEmpty()) {
                throw new InstallException("Failed to create install plan: " + ((LogEvent)log.get(0)).getFormattedMessage(), ((LogEvent)log.get(0)).getThrowable());
            }
            this.notifyStepPropress();
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.notifyPushLevelProgress(actions.size());
            try {
                for (ExtensionPlanAction action : actions) {
                    this.store(action);
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
            this.notifyStepPropress();
            this.notifyPushLevelProgress(actions.size());
            try {
                for (ExtensionPlanAction action : actions) {
                    if (action.getAction() != ExtensionPlanAction.Action.NONE) {
                        this.applyAction(action);
                    }
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private void store(ExtensionPlanAction action) throws LocalExtensionRepositoryException, InstallException {
        if (action.getAction() == ExtensionPlanAction.Action.INSTALL || action.getAction() == ExtensionPlanAction.Action.UPGRADE || action.getAction() == ExtensionPlanAction.Action.DOWNGRADE) {
            this.storeExtension(action.getExtension());
        }
    }

    private void storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        if (!(extension instanceof LocalExtension)) {
            this.logger.info("Downloading [{}]", (Object)extension.getId());
            this.localExtensionRepository.storeExtension(extension);
        }
    }
}

