/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.handler.internal;

import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.handler.ExtensionValidator;
import org.xwiki.job.Request;

public abstract class AbstractExtensionHandler
implements ExtensionHandler {
    @Inject
    protected Logger logger;
    @Inject
    private Provider<ExtensionValidator> defaultValidatorProvider;

    @Override
    public void upgrade(LocalExtension previousLocalExtension, LocalExtension newLocalExtension, String namespace, Request request) throws InstallException {
        try {
            this.uninstall(previousLocalExtension, namespace, request);
        }
        catch (UninstallException e) {
            throw new InstallException("Failed to uninstall previous extension [" + previousLocalExtension + "]");
        }
        this.install(newLocalExtension, namespace, null);
    }

    @Override
    public void initialize(LocalExtension localExtension, String namespace) throws ExtensionException {
    }

    @Override
    public void checkInstall(Extension extension, String namespace, Request request) throws InstallException {
        ((ExtensionValidator)this.defaultValidatorProvider.get()).checkInstall(extension, namespace, request);
    }

    @Override
    public void checkUninstall(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        ((ExtensionValidator)this.defaultValidatorProvider.get()).checkUninstall(extension, namespace, request);
    }
}

