/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.ExtensionStorage;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;

@Component
@Singleton
public class DefaultLocalExtensionRepository
extends AbstractExtensionRepository
implements LocalExtensionRepository,
Initializable,
Searchable {
    @Inject
    private transient ExtensionManagerConfiguration configuration;
    @Inject
    private transient Logger logger;
    @Inject
    private transient ComponentManager componentManager;
    private transient ExtensionStorage storage;
    private transient Map<ExtensionId, DefaultLocalExtension> extensions = new ConcurrentHashMap<ExtensionId, DefaultLocalExtension>();
    private Map<String, List<DefaultLocalExtension>> extensionsVersions = new ConcurrentHashMap<String, List<DefaultLocalExtension>>();

    public void initialize() throws InitializationException {
        try {
            this.storage = new ExtensionStorage(this, this.configuration.getLocalRepository(), this.componentManager);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to intialize local extension storage", (Throwable)e);
        }
        this.setId(new ExtensionRepositoryId("local", "xwiki", this.storage.getRootFolder().toURI()));
        this.storage.loadExtensions();
    }

    protected void addLocalExtension(DefaultLocalExtension localExtension) {
        this.extensions.put(localExtension.getId(), localExtension);
        List<DefaultLocalExtension> versions = this.extensionsVersions.get(localExtension.getId().getId());
        if (versions == null) {
            versions = new ArrayList<DefaultLocalExtension>();
            this.extensionsVersions.put(localExtension.getId().getId(), versions);
            versions.add(localExtension);
        } else {
            int index;
            for (index = 0; index < versions.size() && localExtension.getId().getVersion().compareTo(versions.get(index).getId().getVersion()) < 0; ++index) {
            }
            versions.add(index, localExtension);
        }
    }

    @Override
    public LocalExtension resolve(ExtensionId extensionId) throws ResolveException {
        LocalExtension localExtension = this.extensions.get(extensionId);
        if (localExtension == null) {
            throw new ResolveException("Can't find extension [" + extensionId + "]");
        }
        return localExtension;
    }

    @Override
    public LocalExtension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        List<DefaultLocalExtension> versions = this.extensionsVersions.get(extensionDependency.getId());
        if (versions != null) {
            for (DefaultLocalExtension extension : versions) {
                if (!extensionDependency.getVersionConstraint().containsVersion(extension.getId().getVersion())) continue;
                return extension;
            }
        }
        throw new ResolveException("Can't find extension dependency [" + extensionDependency + "]");
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<DefaultLocalExtension> versions = this.extensionsVersions.get(id);
        if (versions == null) {
            throw new ResolveException("Can't find extension with id [" + id + "]");
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult<Version>(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() - 1 : offset + nb;
        ArrayList<Version> result = new ArrayList<Version>(toId - fromId);
        for (int i = toId - 1; i >= fromId; --i) {
            result.add(versions.get(i).getId().getVersion());
        }
        return new CollectionIterableResult<Version>(versions.size(), offset, result);
    }

    @Override
    public Collection<LocalExtension> getLocalExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public Collection<LocalExtension> getLocalExtensionVersions(String id) {
        Collection versions = this.extensionsVersions.get(id);
        return versions != null ? Collections.unmodifiableCollection(versions) : Collections.emptyList();
    }

    private DefaultLocalExtension createExtension(Extension extension) {
        DefaultLocalExtension localExtension = new DefaultLocalExtension(this, extension);
        localExtension.setFile(this.storage.getNewExtensionFile(localExtension.getId(), localExtension.getType()));
        return localExtension;
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalExtension storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        DefaultLocalExtension localExtension = this.extensions.get(extension.getId());
        if (localExtension == null) {
            try {
                localExtension = this.createExtension(extension);
                InputStream is = extension.getFile().openStream();
                try {
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)localExtension.getFile().getFile());
                }
                finally {
                    is.close();
                }
                this.storage.saveDescriptor(localExtension);
                this.addLocalExtension(localExtension);
            }
            catch (Exception e) {
                throw new LocalExtensionRepositoryException("Failed to save extensoin [" + extension + "] descriptor", e);
            }
        }
        throw new LocalExtensionRepositoryException("Extension [" + extension + "] already exists in local repository");
        return localExtension;
    }

    @Override
    public void setProperties(LocalExtension localExtension, Map<String, Object> properties) throws LocalExtensionRepositoryException {
        DefaultLocalExtension extension = this.extensions.get(localExtension.getId());
        if (extension != null) {
            extension.setProperties(properties);
            try {
                this.storage.saveDescriptor(extension);
            }
            catch (Exception e) {
                throw new LocalExtensionRepositoryException("Failed to save descriptor for extension [" + localExtension + "]", e);
            }
        }
    }

    @Override
    public void removeExtension(LocalExtension extension) throws ResolveException {
        DefaultLocalExtension localExtension = (DefaultLocalExtension)this.resolve(extension.getId());
        try {
            this.storage.removeExtension(localExtension);
        }
        catch (IOException e) {
            this.logger.error("Failed to remove extension [" + extension + "]", (Throwable)e);
        }
        this.extensions.remove(localExtension.getId());
        List<DefaultLocalExtension> localExtensionVersions = this.extensionsVersions.get(localExtension.getId().getId());
        localExtensionVersions.remove(localExtension);
        if (localExtensionVersions.isEmpty()) {
            this.extensionsVersions.remove(localExtension.getId().getId());
        }
    }

    @Override
    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        Pattern patternMatcher = StringUtils.isEmpty((CharSequence)pattern) ? null : Pattern.compile(".*" + pattern + ".*");
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (List<DefaultLocalExtension> versions : this.extensionsVersions.values()) {
            Extension extension = versions.get(0);
            if (patternMatcher != null && !RepositoryUtils.matches(patternMatcher, extension)) continue;
            result.add(extension);
        }
        return RepositoryUtils.searchInCollection(offset, nb, result);
    }
}

