/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.internal.installed.DefaultInstalledExtension;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;

@Component
@Singleton
public class DefaultInstalledExtensionRepository
extends AbstractExtensionRepository
implements InstalledExtensionRepository,
Initializable,
Searchable {
    @Inject
    private transient LocalExtensionRepository localRepository;
    @Inject
    private transient CoreExtensionRepository coreExtensionRepository;
    @Inject
    private transient Logger logger;
    private Map<ExtensionId, DefaultInstalledExtension> extensions = new ConcurrentHashMap<ExtensionId, DefaultInstalledExtension>();
    private Map<String, Map<String, InstalledFeature>> extensionNamespaceByFeature = new ConcurrentHashMap<String, Map<String, InstalledFeature>>();
    private Map<String, List<DefaultInstalledExtension>> extensionsVersionsById = new ConcurrentHashMap<String, List<DefaultInstalledExtension>>();

    public void initialize() throws InitializationException {
        this.setId(new ExtensionRepositoryId("installed", "installed", this.localRepository.getId().getURI()));
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!DefaultInstalledExtension.isInstalled(localExtension)) continue;
            this.validateExtension(localExtension);
        }
    }

    private void validateExtension(LocalExtension localExtension) {
        Collection<String> namespaces = DefaultInstalledExtension.getNamespaces(localExtension);
        if (namespaces == null) {
            try {
                this.validateExtension(localExtension, null);
            }
            catch (InvalidExtensionException e) {
                this.logger.error("Invalid extension [{}] it will not be loaded", (Object)localExtension.getId(), (Object)e);
                this.addInstalledExtension(localExtension, null, false);
            }
        } else {
            for (String namespace : namespaces) {
                try {
                    this.validateExtension(localExtension, namespace);
                }
                catch (InvalidExtensionException e) {
                    this.logger.error("Invalid extension [{}] on namespace [], it will not be loaded", new Object[]{localExtension.getId(), namespace, e});
                    this.addInstalledExtension(localExtension, namespace, false);
                }
            }
        }
    }

    private void validateExtension(LocalExtension localExtension, String namespace) throws InvalidExtensionException {
        InstalledFeature feature = this.getInstalledFeatureFromCache(localExtension.getId().getId(), namespace);
        if (feature != null && StringUtils.equals((CharSequence)feature.namespace, (CharSequence)"namespace")) {
            return;
        }
        if (!DefaultInstalledExtension.isInstalled(localExtension, namespace)) {
            throw new InvalidExtensionException("Extension [" + localExtension + "] is not installed");
        }
        if (this.coreExtensionRepository.exists(localExtension.getId().getId())) {
            throw new InvalidExtensionException("Extension [" + localExtension + "] already exists as a core extension");
        }
        for (ExtensionDependency extensionDependency : localExtension.getDependencies()) {
            CoreExtension coreExtension = this.coreExtensionRepository.getCoreExtension(extensionDependency.getId());
            if (coreExtension != null) {
                if (this.isCompatible(coreExtension.getId().getVersion(), extensionDependency.getVersionConstraint())) continue;
                throw new InvalidExtensionException("Extension [" + localExtension + "] is incompatible with the core extension [" + coreExtension + "]");
            }
            boolean valid = false;
            ArrayList<LocalExtension> dependencyVersions = new ArrayList<LocalExtension>(this.localRepository.getLocalExtensionVersions(extensionDependency.getId()));
            Collections.reverse(dependencyVersions);
            for (LocalExtension dependencyVersion : dependencyVersions) {
                if (!this.isCompatible(dependencyVersion.getId().getVersion(), extensionDependency.getVersionConstraint())) continue;
                try {
                    this.validateExtension(dependencyVersion, namespace);
                    valid = true;
                    break;
                }
                catch (InvalidExtensionException e) {
                }
            }
            if (valid) continue;
            throw new InvalidExtensionException("The dependency [" + extensionDependency + "] of extension [" + localExtension + "] is invalid");
        }
        this.addInstalledExtension(localExtension, namespace, true);
    }

    private boolean isCompatible(Version existingVersion, VersionConstraint versionConstraint) {
        boolean compatible = true;
        compatible = versionConstraint.getVersion() == null ? versionConstraint.containsVersion(existingVersion) : existingVersion.compareTo(versionConstraint.getVersion()) >= 0;
        return compatible;
    }

    private void removeInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) throws UninstallException {
        if (namespace == null) {
            this.extensionNamespaceByFeature.remove(installedExtension.getId().getId());
        } else {
            Map<String, InstalledFeature> namespaceInstalledExtension = this.extensionNamespaceByFeature.get(installedExtension.getId().getId());
            namespaceInstalledExtension.remove(namespace);
        }
        this.removeFromBackwardDependencies(installedExtension, namespace);
        if (!installedExtension.isInstalled()) {
            this.extensions.remove(installedExtension.getId());
        }
    }

    private void applyInstallExtension(DefaultInstalledExtension installedExtension, String namespace) throws InstallException {
        installedExtension.setInstalled(true, namespace);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new InstallException("Failed to modify extension descriptor", e);
        }
        this.addInstalledExtension(installedExtension, namespace, true);
    }

    private void removeFromBackwardDependencies(DefaultInstalledExtension installedExtension, String namespace) {
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            if (this.coreExtensionRepository.getCoreExtension(dependency.getId()) != null) continue;
            InstalledFeature installedFeature = this.getInstalledFeatureFromCache(dependency.getId(), namespace);
            if (installedFeature == null) {
                this.logger.warn("Extension [{}] is not installed", (Object)installedExtension.getId());
                continue;
            }
            if (installedFeature.backwardDependencies.remove(installedExtension)) continue;
            this.logger.warn("Extension [{}] was not regisistered as backward dependency of [{}]", (Object)installedExtension.getId(), (Object)installedFeature.extension.getId());
        }
    }

    private void addInstalledExtension(LocalExtension localExtension, String namespace, boolean valid) {
        DefaultInstalledExtension installedExtension = this.extensions.get(localExtension.getId());
        if (installedExtension == null) {
            installedExtension = new DefaultInstalledExtension(localExtension, this);
        }
        installedExtension.setInstalled(true, namespace);
        installedExtension.setValid(namespace, valid);
        this.addInstalledExtension(installedExtension, namespace);
    }

    private void addInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) {
        this.extensions.put(installedExtension.getId(), installedExtension);
        this.addInstalledFeatureToCache(installedExtension.getId().getId(), namespace, installedExtension);
        for (String feature : installedExtension.getFeatures()) {
            this.addInstalledFeatureToCache(feature, namespace, installedExtension);
        }
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            if (this.coreExtensionRepository.exists(dependency.getId())) continue;
            DefaultInstalledExtension dependencyLocalExtension = (DefaultInstalledExtension)this.getInstalledExtension(dependency.getId(), namespace);
            InstalledFeature dependencyInstalledExtension = this.addInstalledFeatureToCache(dependency.getId(), namespace, dependencyLocalExtension);
            dependencyInstalledExtension.backwardDependencies.add(installedExtension);
        }
    }

    private InstalledFeature addInstalledFeatureToCache(String feature, String namespace, DefaultInstalledExtension localExtension) {
        InstalledFeature installedExtension;
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsForFeature == null) {
            installedExtensionsForFeature = new HashMap<String, InstalledFeature>();
            this.extensionNamespaceByFeature.put(feature, installedExtensionsForFeature);
        }
        if ((installedExtension = installedExtensionsForFeature.get(namespace)) == null) {
            installedExtension = new InstalledFeature(localExtension, feature, namespace);
            installedExtensionsForFeature.put(namespace, installedExtension);
        }
        return installedExtension;
    }

    private InstalledFeature getInstalledFeatureFromCache(String feature, String namespace) {
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsForFeature == null) {
            return null;
        }
        InstalledFeature installedExtension = installedExtensionsForFeature.get(namespace);
        if (installedExtension == null && namespace != null) {
            installedExtension = this.getInstalledFeatureFromCache(feature, null);
        }
        return installedExtension;
    }

    @Override
    public InstalledExtension resolve(ExtensionId extensionId) throws ResolveException {
        InstalledExtension extension = this.extensions.get(extensionId);
        if (extension == null) {
            throw new ResolveException("Extension [" + extensionId + "] is not installed");
        }
        return extension;
    }

    @Override
    public InstalledExtension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        List<DefaultInstalledExtension> versions = this.extensionsVersionsById.get(extensionDependency.getId());
        if (versions != null) {
            for (DefaultInstalledExtension extension : versions) {
                if (!extensionDependency.getVersionConstraint().containsVersion(extension.getId().getVersion())) continue;
                return extension;
            }
        }
        throw new ResolveException("Can't find extension dependency [" + extensionDependency + "]");
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<DefaultInstalledExtension> versions = this.extensionsVersionsById.get(id);
        if (versions == null) {
            throw new ResolveException("Can't find extension with id [" + id + "]");
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult<Version>(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() - 1 : offset + nb;
        ArrayList<Version> result = new ArrayList<Version>(toId - fromId);
        for (int i = toId - 1; i >= fromId; --i) {
            result.add(versions.get(i).getId().getVersion());
        }
        return new CollectionIterableResult<Version>(versions.size(), offset, result);
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        ArrayList<InstalledExtension> result = new ArrayList<InstalledExtension>(this.extensions.size());
        for (DefaultInstalledExtension installedExtension : this.extensions.values()) {
            if (!installedExtension.isInstalled(namespace)) continue;
            result.add(installedExtension);
        }
        return result;
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        InstalledFeature installedFeature = this.getInstalledFeatureFromCache(feature, namespace);
        if (installedFeature != null) {
            return installedFeature.extension;
        }
        return null;
    }

    @Override
    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        LocalExtension localExtension;
        DefaultInstalledExtension installedExtension = this.extensions.get(extension.getId());
        if (installedExtension != null && installedExtension.isInstalled(namespace)) {
            if (installedExtension.isDependency() == dependency) {
                throw new InstallException("The extension [" + installedExtension + "] is already installed on namespace [" + namespace + "]");
            }
            installedExtension.setDependency(dependency);
            try {
                this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
            }
            catch (Exception e) {
                throw new InstallException("Failed to modify extension descriptor", e);
            }
        }
        try {
            localExtension = this.localRepository.resolve(extension.getId());
        }
        catch (ResolveException e) {
            throw new InstallException("The extension [" + extension + "] need to be stored first");
        }
        if (installedExtension == null) {
            installedExtension = new DefaultInstalledExtension(localExtension, this);
        }
        if (dependency || installedExtension.getProperty("installed.dependency") == null) {
            installedExtension.setDependency(dependency);
        }
        this.applyInstallExtension(installedExtension, namespace);
        return installedExtension;
    }

    @Override
    public void uninstallExtension(InstalledExtension extension, String namespace) throws UninstallException {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.getInstalledExtension(extension.getId().getId(), namespace);
        if (installedExtension != null) {
            this.applyUninstallExtension(installedExtension, namespace);
        }
    }

    private void applyUninstallExtension(DefaultInstalledExtension installedExtension, String namespace) throws UninstallException {
        installedExtension.setInstalled(false, namespace);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new UninstallException("Failed to modify extension descriptor", e);
        }
        this.removeInstalledExtension(installedExtension, namespace);
    }

    @Override
    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace) throws ResolveException {
        InstalledFeature installedExtension;
        if (this.getInstalledExtension(feature, namespace) == null) {
            throw new ResolveException("Extension [" + feature + "] is not installed on namespace [" + namespace + "]");
        }
        Map<String, InstalledFeature> installedExtensionsByFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsByFeature != null && (installedExtension = installedExtensionsByFeature.get(namespace)) != null) {
            Set<DefaultInstalledExtension> backwardDependencies = installedExtension.backwardDependencies;
            return backwardDependencies != null ? new ArrayList<DefaultInstalledExtension>(backwardDependencies) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        Map<String, Collection<InstalledExtension>> result;
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.resolve(extensionId);
        Collection<String> namespaces = installedExtension.getNamespaces();
        Map<String, InstalledFeature> featureExtensions = this.extensionNamespaceByFeature.get(installedExtension.getId().getId());
        if (featureExtensions != null) {
            result = new HashMap();
            for (InstalledFeature festureExtension : featureExtensions.values()) {
                if (namespaces != null && !namespaces.contains(festureExtension.namespace) || festureExtension.backwardDependencies.isEmpty()) continue;
                result.put(festureExtension.namespace, new ArrayList<DefaultInstalledExtension>(festureExtension.backwardDependencies));
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    @Override
    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        return RepositoryUtils.searchInCollection(pattern, offset, nb, this.extensions.values());
    }

    private static class InstalledFeature {
        public DefaultInstalledExtension extension;
        public String feature;
        public String namespace;
        public Set<DefaultInstalledExtension> backwardDependencies = new HashSet<DefaultInstalledExtension>();

        public InstalledFeature(DefaultInstalledExtension extension, String feature, String namespace) {
            this.extension = extension;
            this.feature = feature;
            this.namespace = namespace;
        }
    }
}

