/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.LocalExtensionFile;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;

public class DefaultInstalledExtension
extends AbstractExtension
implements InstalledExtension {
    private LocalExtension localExtension;
    private Map<String, Boolean> valid = new HashMap<String, Boolean>();

    public DefaultInstalledExtension(LocalExtension localExtension, InstalledExtensionRepository repository) {
        super(repository, localExtension);
        this.localExtension = localExtension;
    }

    static boolean isInstalled(Extension extension) {
        return extension.getProperty("installed.installed", false);
    }

    public static boolean isInstalled(Extension extension, String namespace) {
        return DefaultInstalledExtension.isInstalled(extension) && (DefaultInstalledExtension.getNamespaces(extension) == null || DefaultInstalledExtension.getNamespaces(extension).contains(namespace));
    }

    public static Collection<String> getNamespaces(Extension extension) {
        return extension.getProperty("installed.namespaces", null);
    }

    @Override
    public ExtensionRepository getRepository() {
        return this.repository;
    }

    @Override
    public LocalExtension getLocalExtension() {
        return this.localExtension;
    }

    private Collection<String> getNamespaces(boolean create) {
        HashSet namespaces = this.getProperty("installed.namespaces", null);
        if (namespaces == null && create) {
            namespaces = new HashSet();
            this.putProperty("installed.namespaces", namespaces);
        }
        return namespaces;
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.getNamespaces(false);
    }

    public void setNamespaces(Collection<String> namespaces) {
        this.putProperty("installed.namespaces", namespaces != null ? new HashSet<String>(namespaces) : null);
    }

    public void addNamespace(String namespace) {
        this.getNamespaces(true).add(namespace);
    }

    @Override
    public boolean isInstalled() {
        return DefaultInstalledExtension.isInstalled(this);
    }

    @Override
    public boolean isInstalled(String namespace) {
        return DefaultInstalledExtension.isInstalled(this, namespace);
    }

    public void setInstalled(boolean installed) {
        this.putProperty("installed.installed", installed);
    }

    public void setInstalled(boolean installed, String namespace) {
        if (namespace == null) {
            if (installed && !this.isInstalled()) {
                this.setValid(namespace, true);
            }
            this.setInstalled(installed);
            this.setNamespaces(null);
        } else if (installed) {
            if (!this.isInstalled(namespace)) {
                this.setValid(namespace, true);
            }
            this.setInstalled(true);
            this.addNamespace(namespace);
        } else {
            Collection<String> namespaces = this.getNamespaces(false);
            if (namespaces != null) {
                namespaces.remove(namespace);
                if (this.getNamespaces().isEmpty()) {
                    this.setInstalled(false);
                    this.setNamespaces(null);
                }
            }
        }
        if (!installed) {
            this.valid.remove(namespace);
        }
    }

    @Override
    public boolean isValid(String namespace) {
        Boolean isvalid = this.valid.get(namespace);
        return isvalid != null ? isvalid : true;
    }

    public void setValid(String namespace, boolean valid) {
        this.valid.put(namespace, valid);
    }

    @Override
    public boolean isDependency() {
        return this.getProperty("installed.dependency", false);
    }

    public void setDependency(boolean dependency) {
        this.putProperty("installed.dependency", dependency);
    }

    @Override
    public LocalExtensionFile getFile() {
        return this.getLocalExtension().getFile();
    }
}

