/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.handler.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Singleton
public class DefaultExtensionInitializer
implements ExtensionInitializer {
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private Logger logger;

    @Override
    public void initialize() {
        this.initialize(null, null);
    }

    @Override
    public void initialize(String namespaceToLoad) {
        this.initialize(namespaceToLoad, null);
    }

    @Override
    public void initialize(String namespaceToLoad, String type) {
        HashMap<String, Set<InstalledExtension>> loadedExtensions = new HashMap<String, Set<InstalledExtension>>();
        Collection<InstalledExtension> installedExtensions = namespaceToLoad != null ? this.installedExtensionRepository.getInstalledExtensions(namespaceToLoad) : this.installedExtensionRepository.getInstalledExtensions();
        for (InstalledExtension installedExtension : installedExtensions) {
            if (type != null && !type.equals(installedExtension.getType())) continue;
            try {
                this.loadExtension(installedExtension, namespaceToLoad, loadedExtensions);
            }
            catch (Exception e) {
                this.logger.error("Failed to initialize local extension [" + installedExtension + "]", (Throwable)e);
            }
        }
    }

    private void loadExtension(InstalledExtension installedExtension, String namespaceToLoad, Map<String, Set<InstalledExtension>> loadedExtensions) throws ExtensionException {
        if (installedExtension.getNamespaces() != null) {
            if (namespaceToLoad == null) {
                for (String namespace : installedExtension.getNamespaces()) {
                    this.loadExtensionInNamespace(installedExtension, namespace, loadedExtensions);
                }
            } else if (installedExtension.getNamespaces().contains(namespaceToLoad)) {
                this.loadExtensionInNamespace(installedExtension, namespaceToLoad, loadedExtensions);
            }
        } else if (namespaceToLoad == null) {
            this.loadExtensionInNamespace(installedExtension, null, loadedExtensions);
        }
    }

    private void loadExtensionInNamespace(InstalledExtension installedExtension, String namespace, Map<String, Set<InstalledExtension>> loadedExtensions) throws ExtensionException {
        if (!installedExtension.isValid(namespace)) {
            return;
        }
        Set<InstalledExtension> loadedExtensionsInNamespace = loadedExtensions.get(namespace);
        if (loadedExtensionsInNamespace == null) {
            loadedExtensionsInNamespace = new HashSet<InstalledExtension>();
            loadedExtensions.put(namespace, loadedExtensionsInNamespace);
        }
        if (!loadedExtensionsInNamespace.contains(installedExtension)) {
            for (ExtensionDependency extensionDependency : installedExtension.getDependencies()) {
                if (this.coreExtensionRepository.exists(extensionDependency.getId())) continue;
                InstalledExtension dependencyExtension = this.installedExtensionRepository.getInstalledExtension(extensionDependency.getId(), namespace);
                this.loadExtensionInNamespace(dependencyExtension, namespace, loadedExtensions);
            }
            this.extensionHandlerManager.initialize(installedExtension, namespace);
            loadedExtensionsInNamespace.add(installedExtension);
        }
    }
}

