/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.internal.ExtensionManagerConfigurationException;
import org.xwiki.extension.repository.ExtensionRepositoryId;

@Component
@Singleton
public class DefaultExtensionManagerConfiguration
implements ExtensionManagerConfiguration {
    private static final Pattern REPOSITORYIDPATTERN = Pattern.compile("([^:]+):([^:]+):(.+)");
    private static final String DEFAULT_USERAGENT = "XWikiExtensionManager";
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    private Provider<ConfigurationSource> configuration;
    private File localRepository;

    public File getHome() {
        return new File(this.environment.getPermanentDirectory(), "extension/");
    }

    @Override
    public File getLocalRepository() {
        if (this.localRepository == null) {
            String localRepositoryPath = (String)((ConfigurationSource)this.configuration.get()).getProperty("extension.localRepository");
            this.localRepository = localRepositoryPath == null ? new File(this.getHome(), "repository/") : new File(localRepositoryPath);
        }
        return this.localRepository;
    }

    @Override
    public Collection<ExtensionRepositoryId> getRepositories() {
        Collection repositories;
        List repositoryStrings = (List)((ConfigurationSource)this.configuration.get()).getProperty("extension.repositories", Collections.emptyList());
        if (repositoryStrings.isEmpty()) {
            repositories = null;
        } else {
            LinkedHashMap<String, ExtensionRepositoryId> repositoriesMap = new LinkedHashMap<String, ExtensionRepositoryId>();
            for (String repositoryString : repositoryStrings) {
                if (StringUtils.isNotBlank((CharSequence)repositoryString)) {
                    try {
                        ExtensionRepositoryId extensionRepositoryId = this.parseRepository(repositoryString);
                        if (repositoriesMap.containsKey(extensionRepositoryId.getId())) {
                            this.logger.warn("Duplicated repository id in [{}] first found in [{}]. The last one will be used.", (Object)extensionRepositoryId, repositoriesMap.get(extensionRepositoryId.getId()));
                        }
                        repositoriesMap.put(extensionRepositoryId.getId(), extensionRepositoryId);
                    }
                    catch (Exception e) {
                        this.logger.warn("Faild to parse repository [" + repositoryString + "] from configuration", (Throwable)e);
                    }
                    continue;
                }
                this.logger.debug("Empty repository id found in the configuration");
            }
            repositories = repositoriesMap.values();
        }
        return repositories;
    }

    private ExtensionRepositoryId parseRepository(String repositoryString) throws URISyntaxException, ExtensionManagerConfigurationException {
        Matcher matcher = REPOSITORYIDPATTERN.matcher(repositoryString);
        if (matcher.matches()) {
            return new ExtensionRepositoryId(matcher.group(1), matcher.group(2), new URI(matcher.group(3)));
        }
        throw new ExtensionManagerConfigurationException("Don't match repository configuration [" + repositoryString + "]");
    }

    @Override
    public String getUserAgent() {
        return (String)((ConfigurationSource)this.configuration.get()).getProperty("extension.userAgent", (Object)DEFAULT_USERAGENT);
    }
}

