/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionFile;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionRepository;
import org.xwiki.extension.repository.internal.local.ExtensionSerializer;

public class ExtensionStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionStorage.class);
    private static final String DESCRIPTOR_EXT = "xed";
    private static final String DESCRIPTOR_SUFFIX = ".xed";
    private DefaultLocalExtensionRepository repository;
    private ExtensionSerializer extensionSerializer;
    private File rootFolder;
    private ComponentManager componentManager;

    public ExtensionStorage(DefaultLocalExtensionRepository repository, File rootFolder, ComponentManager componentManager) throws ComponentLookupException {
        this.repository = repository;
        this.rootFolder = rootFolder;
        this.componentManager = componentManager;
        this.extensionSerializer = (ExtensionSerializer)this.componentManager.lookupComponent(ExtensionSerializer.class);
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    protected void loadExtensions() {
        if (this.rootFolder.exists()) {
            this.loadExtensions(this.rootFolder);
        } else {
            this.rootFolder.mkdirs();
        }
    }

    protected void loadExtensions(File folder) {
        for (File child : folder.listFiles()) {
            if (child.isDirectory()) {
                this.loadExtensions(child);
                continue;
            }
            if (!child.getName().endsWith(DESCRIPTOR_SUFFIX)) continue;
            try {
                DefaultLocalExtension localExtension = this.loadDescriptor(child);
                this.repository.addLocalExtension(localExtension);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load extension from file [" + child + "] in local repository", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultLocalExtension loadDescriptor(File descriptor) throws InvalidExtensionException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(descriptor);
        }
        catch (FileNotFoundException e) {
            throw new InvalidExtensionException("Failed to open descriptor for reading", e);
        }
        try {
            DefaultLocalExtension localExtension = this.extensionSerializer.loadDescriptor(this.repository, fis);
            localExtension.setDescriptorFile(descriptor);
            localExtension.setFile(this.getFile(descriptor, DESCRIPTOR_EXT, localExtension.getType()));
            if (!localExtension.getFile().getFile().exists()) {
                throw new InvalidExtensionException("Failed to load local extension [" + descriptor + "]: [" + localExtension.getFile() + "] file does not exists");
            }
            DefaultLocalExtension defaultLocalExtension = localExtension;
            return defaultLocalExtension;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close stream for file [" + descriptor + "]", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDescriptor(DefaultLocalExtension extension) throws ParserConfigurationException, TransformerException, IOException {
        File file = extension.getDescriptorFile();
        if (file == null) {
            file = this.getNewDescriptorFile(extension.getId());
            extension.setDescriptorFile(file);
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.extensionSerializer.saveDescriptor(extension, fos);
        }
        finally {
            fos.close();
        }
    }

    protected File getNewExtensionFile(ExtensionId id, String type) {
        return new File(this.getRootFolder(), this.getFilePath(id, type));
    }

    private File getNewDescriptorFile(ExtensionId id) {
        return new File(this.getRootFolder(), this.getFilePath(id, DESCRIPTOR_EXT));
    }

    private File getFile(File baseFile, String baseType, String type) {
        String baseName = this.getBaseName(baseFile.getName(), baseType);
        return new File(baseFile.getParent(), baseName + '.' + this.encode(type));
    }

    private String getBaseName(String fileName, String type) {
        return fileName.substring(0, fileName.length() - this.encode(type).length() - 1);
    }

    private String encode(String name) {
        String encoded;
        try {
            encoded = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encoded = name;
        }
        return encoded;
    }

    private String getFilePath(ExtensionId id, String fileExtension) {
        String encodedId = this.encode(id.getId());
        String encodedVersion = this.encode(id.getVersion().toString());
        String encodedType = this.encode(fileExtension);
        return encodedId + File.separator + encodedVersion + File.separator + encodedId + '-' + encodedVersion + '.' + encodedType;
    }

    public void removeExtension(DefaultLocalExtension extension) throws IOException {
        File descriptorFile = extension.getDescriptorFile();
        if (descriptorFile == null) {
            throw new IOException("Exception does not exists");
        }
        descriptorFile.delete();
        DefaultLocalExtensionFile extensionFile = extension.getFile();
        extensionFile.getFile().delete();
    }
}

