/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.util.Collection;
import java.util.HashSet;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.LocalExtensionFile;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;

public class DefaultInstalledExtension
extends AbstractExtension
implements InstalledExtension {
    private LocalExtension localExtension;

    public DefaultInstalledExtension(LocalExtension localExtension, InstalledExtensionRepository repository) {
        super(repository, localExtension);
        this.localExtension = localExtension;
    }

    static boolean isInstalled(Extension extension) {
        return extension.getProperty("installed.installed", false);
    }

    public static boolean isInstalled(Extension extension, String namespace) {
        return DefaultInstalledExtension.isInstalled(extension) && (DefaultInstalledExtension.getNamespaces(extension) == null || DefaultInstalledExtension.getNamespaces(extension).contains(namespace));
    }

    public static Collection<String> getNamespaces(Extension extension) {
        return extension.getProperty("installed.namespaces", null);
    }

    @Override
    public ExtensionRepository getRepository() {
        return this.repository;
    }

    @Override
    public LocalExtension getLocalExtension() {
        return this.localExtension;
    }

    private Collection<String> getNamespaces(boolean create) {
        HashSet namespaces = this.getProperty("installed.namespaces", null);
        if (namespaces == null && create) {
            namespaces = new HashSet();
            this.putProperty("installed.namespaces", namespaces);
        }
        return namespaces;
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.getNamespaces(false);
    }

    public void setNamespaces(Collection<String> namespaces) {
        this.putProperty("installed.namespaces", namespaces != null ? new HashSet<String>(namespaces) : null);
    }

    public void addNamespace(String namespace) {
        this.getNamespaces(true).add(namespace);
    }

    @Override
    public boolean isInstalled() {
        return DefaultInstalledExtension.isInstalled(this);
    }

    @Override
    public boolean isInstalled(String namespace) {
        return DefaultInstalledExtension.isInstalled(this, namespace);
    }

    public void setInstalled(boolean installed) {
        this.putProperty("installed.installed", installed);
    }

    public void setInstalled(boolean installed, String namespace) {
        if (namespace == null) {
            this.setInstalled(installed);
            this.setNamespaces(null);
        } else if (installed) {
            this.setInstalled(true);
            this.addNamespace(namespace);
        } else if (this.getNamespaces() != null) {
            this.getNamespaces().remove(namespace);
            if (this.getNamespaces().isEmpty()) {
                this.setInstalled(false);
                this.setNamespaces(null);
            }
        }
    }

    @Override
    public boolean isDependency() {
        return this.getProperty("installed.dependency", false);
    }

    public void setDependency(boolean dependency) {
        this.putProperty("installed.dependency", dependency);
    }

    @Override
    public LocalExtensionFile getFile() {
        return this.getLocalExtension().getFile();
    }
}

