/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.extension.repository.internal.local.AbstractExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.local.ExtensionPropertySerializer;

public class CollectionExtensionPropertySerializer<C extends Collection>
extends AbstractExtensionPropertySerializer<C> {
    protected Map<String, ExtensionPropertySerializer> serializerById;
    protected Map<Class<?>, ExtensionPropertySerializer> serializerByClass;

    protected CollectionExtensionPropertySerializer(String type, Map<String, ExtensionPropertySerializer> serializerById, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        super(type);
        this.serializerById = serializerById;
    }

    public CollectionExtensionPropertySerializer(Map<String, ExtensionPropertySerializer> serializerById, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        this("collection", serializerById, serializerByClass);
    }

    protected C createCollection() {
        return (C)new ArrayList();
    }

    public static Object toValue(Element element, Map<String, ExtensionPropertySerializer> serializerById) {
        String type = element.getAttribute("type");
        ExtensionPropertySerializer serializer = serializerById.get(type);
        return serializer != null ? serializer.toValue(element) : null;
    }

    public static Element toElement(Object value, Document document, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        ExtensionPropertySerializer serializer = serializerByClass.get(serializerByClass.getClass());
        return serializer != null ? serializer.toElement(document, null, value) : null;
    }

    @Override
    public C toValue(Element element) {
        C collection = this.createCollection();
        NodeList featuresNodes = element.getChildNodes();
        for (int i = 0; i < featuresNodes.getLength(); ++i) {
            Object value;
            Node node = featuresNodes.item(i);
            if (node.getNodeType() != 9 || (value = CollectionExtensionPropertySerializer.toValue((Element)node, this.serializerById)) != null) continue;
            return null;
        }
        return collection;
    }

    @Override
    public Element toElement(Document document, String elementName, C elementValue) {
        Element element = this.createRootElement(document, elementName);
        for (Object subValue : elementValue) {
            Element subElement = CollectionExtensionPropertySerializer.toElement(subValue, document, this.serializerByClass);
            if (subElement == null) {
                return null;
            }
            element.appendChild(subElement);
        }
        return element;
    }
}

