/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.safe;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.extension.internal.safe.ScriptSafeProvider;

@Component
@Singleton
public class DefaultScriptSafeProvider
implements ScriptSafeProvider {
    @Inject
    private ComponentManager component;

    public Object get(Object unsafe) {
        if (unsafe == null) {
            return null;
        }
        Object safe = this.get(unsafe, Arrays.asList(unsafe.getClass()));
        if (safe == null) {
            safe = unsafe;
        }
        return safe;
    }

    private Object get(Object unsafe, List<Type> types) {
        Object safe;
        for (Type type : types) {
            safe = this.get(unsafe, type);
            if (safe == null) continue;
            return safe;
        }
        for (Type type : types) {
            safe = this.get(unsafe, ReflectionUtils.getDirectTypes((Type)type));
            if (safe == null) continue;
            return safe;
        }
        return null;
    }

    private Object get(Object unsafe, Type type) {
        try {
            ScriptSafeProvider provider = (ScriptSafeProvider)this.component.lookupComponent((Type)new DefaultParameterizedType(null, ScriptSafeProvider.class, new Type[]{type}));
            return provider.get(unsafe);
        }
        catch (ComponentLookupException e) {
            if (type instanceof ParameterizedType) {
                try {
                    ScriptSafeProvider provider = (ScriptSafeProvider)this.component.lookupComponent(((ParameterizedType)type).getRawType());
                    return provider.get(unsafe);
                }
                catch (ComponentLookupException e1) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

