/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.File;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.ExtensionManagerConfigurationException;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultExtensionManagerConfiguration
implements ExtensionManagerConfiguration {
    private static final Pattern REPOSITORYIDPATTERN = Pattern.compile("([^:]+):([^:]+):(.+)");
    private static final String DEFAULT_USERAGENT = "XWikiExtensionManager";
    private static final String CK_PREFIX = "extension.";
    private static final String CK_CORE_PREFIX = "extension.core.";
    private static final String CK_REPOSITORIES_PREFIX = "extension.repositories.";
    private static final String CK_IGNORED_DEPENDENCIES = "extension.ignoredDependencies";
    private static final Set<String> DEFAULT_IGNORED_DEPENDENCIES = new HashSet<String>(Arrays.asList("stax:stax", "javax.xml.stream:stax-api", "stax:stax-api", "xalan:xalan", "xalan:serializer", "xml-apis:xml-apis", "xerces:xmlParserAPIs"));
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    private Provider<ConfigurationSource> configuration;
    @Inject
    private ExtensionFactory extensionFactory;
    @Inject
    private Provider<CoreExtensionRepository> coreExtensionRepository;
    @Inject
    private ConverterManager converter;
    private File localRepository;
    private List<RecommendedVersion> recommendedVersions;

    public File getHome() {
        return new File(this.environment.getPermanentDirectory(), "extension/");
    }

    @Override
    public File getLocalRepository() {
        if (this.localRepository == null) {
            String localRepositoryPath = (String)((ConfigurationSource)this.configuration.get()).getProperty("extension.localRepository");
            this.localRepository = localRepositoryPath == null ? new File(this.getHome(), "repository/") : new File(localRepositoryPath);
        }
        return this.localRepository;
    }

    @Override
    public Collection<ExtensionRepositoryDescriptor> getExtensionRepositoryDescriptors() {
        Collection repositories;
        List repositoryStrings = (List)((ConfigurationSource)this.configuration.get()).getProperty("extension.repositories", Collections.emptyList());
        if (repositoryStrings.isEmpty()) {
            repositories = null;
        } else {
            LinkedHashMap<String, ExtensionRepositoryDescriptor> repositoriesMap = new LinkedHashMap<String, ExtensionRepositoryDescriptor>();
            for (String repositoryString : repositoryStrings) {
                if (StringUtils.isNotBlank((CharSequence)repositoryString)) {
                    try {
                        ExtensionRepositoryDescriptor extensionRepositoryId = this.parseRepository(repositoryString);
                        if (repositoriesMap.containsKey(extensionRepositoryId.getId())) {
                            this.logger.warn("Duplicated repository id in [{}] first found in [{}]. The last one will be used.", (Object)extensionRepositoryId, repositoriesMap.get(extensionRepositoryId.getId()));
                        }
                        repositoriesMap.put(extensionRepositoryId.getId(), extensionRepositoryId);
                    }
                    catch (Exception e) {
                        this.logger.warn("Ignoring invalid repository configuration [{}]. Root cause [{}]", (Object)repositoryString, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    continue;
                }
                this.logger.debug("Empty repository id found in the configuration");
            }
            repositories = repositoriesMap.values();
            for (ExtensionRepositoryDescriptor descriptor : repositories) {
                this.setRepositoryProperties((DefaultExtensionRepositoryDescriptor)descriptor);
            }
        }
        return repositories;
    }

    private void setRepositoryProperties(DefaultExtensionRepositoryDescriptor descriptor) {
        String id = descriptor.getId();
        ConfigurationSource configurationSource = (ConfigurationSource)this.configuration.get();
        String prefix = CK_REPOSITORIES_PREFIX + id + ".";
        for (String key : configurationSource.getKeys(prefix)) {
            descriptor.putProperty(key.substring(prefix.length()), (String)configurationSource.getProperty(key, String.class));
        }
    }

    @Override
    public Collection<ExtensionRepositoryId> getRepositories() {
        ArrayList<ExtensionRepositoryId> repositories = new ArrayList<ExtensionRepositoryId>();
        for (ExtensionRepositoryDescriptor descriptor : this.getExtensionRepositoryDescriptors()) {
            repositories.add(new ExtensionRepositoryId(descriptor));
        }
        return repositories;
    }

    private ExtensionRepositoryDescriptor parseRepository(String repositoryString) throws URISyntaxException, ExtensionManagerConfigurationException {
        Matcher matcher = REPOSITORYIDPATTERN.matcher(repositoryString);
        if (matcher.matches()) {
            return this.extensionFactory.getExtensionRepositoryDescriptor(matcher.group(1), matcher.group(2), new URI(matcher.group(3)), null);
        }
        throw new ExtensionManagerConfigurationException(String.format("Invalid repository configuration format for [%s]. Should have been matching [%s].", repositoryString, REPOSITORYIDPATTERN.toString()));
    }

    @Override
    public String getUserAgent() {
        return (String)((ConfigurationSource)this.configuration.get()).getProperty("extension.userAgent", (Object)DEFAULT_USERAGENT);
    }

    @Override
    public boolean resolveCoreExtensions() {
        return (Boolean)((ConfigurationSource)this.configuration.get()).getProperty("extension.core.resolve", (Object)true);
    }

    protected List<String> getRecommendedVersions() {
        Object configurationValue = ((ConfigurationSource)this.configuration.get()).getProperty("extension.recommendedVersions");
        if (configurationValue != null) {
            if (configurationValue instanceof List) {
                return (List)configurationValue;
            }
            return ExtensionUtils.importPropertyStringList(configurationValue.toString(), true);
        }
        CoreExtensionRepository repository = (CoreExtensionRepository)this.coreExtensionRepository.get();
        CoreExtension environmentExtension = repository.getEnvironmentExtension();
        if (environmentExtension != null) {
            String listString = (String)environmentExtension.getProperty("xwiki.extension.recommendedVersions");
            return ExtensionUtils.importPropertyStringList(listString, true);
        }
        return null;
    }

    private RecommendedVersion getRecomendedVersion(String id) {
        if (this.recommendedVersions == null) {
            List<String> list = this.getRecommendedVersions();
            if (list != null) {
                List extensions = (List)this.converter.convert((Type)ExtensionId.TYPE_LIST, list);
                ArrayList<RecommendedVersion> versions = new ArrayList<RecommendedVersion>(extensions.size());
                for (ExtensionId extensionId : extensions) {
                    versions.add(new RecommendedVersion(Pattern.compile(extensionId.getId()), this.extensionFactory.getVersionConstraint(extensionId.getVersion().getValue())));
                }
                this.recommendedVersions = versions;
            } else {
                this.recommendedVersions = Collections.emptyList();
            }
        }
        for (RecommendedVersion version : this.recommendedVersions) {
            if (!version.matches(id)) continue;
            return version;
        }
        return null;
    }

    @Override
    public VersionConstraint getRecomendedVersionConstraint(String id) {
        RecommendedVersion recommendedVersion = this.getRecomendedVersion(id);
        if (recommendedVersion != null) {
            return recommendedVersion.getVersionConstraint();
        }
        return null;
    }

    @Override
    public VersionConstraint getRecomendedVersionConstraint(String id, VersionConstraint defaultVersion) {
        VersionConstraint constraint = this.getRecomendedVersionConstraint(id);
        if (constraint != null && !constraint.equals(defaultVersion)) {
            return constraint;
        }
        return null;
    }

    @Override
    public boolean isIgnoredDependency(ExtensionDependency dependency) {
        Set ignoredDependencies = (Set)((ConfigurationSource)this.configuration.get()).getProperty(CK_IGNORED_DEPENDENCIES, DEFAULT_IGNORED_DEPENDENCIES);
        return ignoredDependencies.contains(dependency.getId());
    }

    private static class RecommendedVersion {
        private Pattern idPattern;
        private VersionConstraint versionConstraint;

        RecommendedVersion(Pattern idPattern, VersionConstraint version) {
            this.idPattern = idPattern;
            this.versionConstraint = version;
        }

        boolean matches(String id) {
            return this.idPattern.matcher(id).matches();
        }

        public VersionConstraint getVersionConstraint() {
            return this.versionConstraint;
        }
    }
}

