/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionNotFoundException;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.AdvancedSearchable;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.version.Version;

public abstract class AbstractCachedExtensionRepository<E extends Extension>
extends AbstractExtensionRepository
implements AdvancedSearchable {
    protected transient Map<ExtensionId, E> extensions = new ConcurrentHashMap<ExtensionId, E>();
    protected Map<String, List<E>> extensionsVersions = new ConcurrentHashMap<String, List<E>>();
    private boolean strictId;

    protected AbstractCachedExtensionRepository() {
        this(false);
    }

    protected AbstractCachedExtensionRepository(boolean strict) {
        this.strictId = strict;
    }

    @Override
    public boolean isFilterable() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    protected void addCachedExtension(E extension) {
        if (!this.extensions.containsKey(extension.getId())) {
            this.extensions.put(extension.getId(), extension);
            this.addCachedExtensionVersion(extension.getId().getId(), extension);
            if (!this.strictId) {
                for (String feature : extension.getFeatures()) {
                    this.addCachedExtensionVersion(feature, extension);
                }
            }
        }
    }

    protected void addCachedExtensionVersion(String feature, E extension) {
        List<E> versions = this.extensionsVersions.get(feature);
        if (versions == null) {
            versions = new ArrayList();
            this.extensionsVersions.put(feature, versions);
            versions.add(extension);
        } else {
            int index;
            for (index = 0; index < versions.size() && extension.getId().getVersion().compareTo(((Extension)versions.get(index)).getId().getVersion()) < 0; ++index) {
            }
            versions.add(index, extension);
        }
    }

    protected void removeCachedExtension(E extension) {
        this.extensions.remove(extension.getId());
        this.removeCachedExtensionVersion(extension.getId().getId(), extension);
        if (!this.strictId) {
            for (String feature : extension.getFeatures()) {
                this.removeCachedExtensionVersion(feature, extension);
            }
        }
    }

    protected void removeCachedExtensionVersion(String feature, E extension) {
        List<E> extensionVersions = this.extensionsVersions.get(feature);
        extensionVersions.remove(extension);
        if (extensionVersions.isEmpty()) {
            this.extensionsVersions.remove(feature);
        }
    }

    public E resolve(ExtensionId extensionId) throws ResolveException {
        Extension extension = (Extension)this.extensions.get(extensionId);
        if (extension == null) {
            throw new ExtensionNotFoundException("Can't find extension [" + String.valueOf(extensionId) + "]");
        }
        return (E)extension;
    }

    public E resolve(ExtensionDependency extensionDependency) throws ResolveException {
        List<E> versions = this.extensionsVersions.get(extensionDependency.getId());
        if (versions != null) {
            for (Extension extension : versions) {
                if (!extensionDependency.getVersionConstraint().containsVersion(extension.getId().getVersion())) continue;
                return (E)extension;
            }
        }
        throw new ExtensionNotFoundException("Can't find extension dependency [" + String.valueOf(extensionDependency) + "]");
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        if (id == null) {
            return new CollectionIterableResult<Version>(0, offset, Collections.emptyList());
        }
        List<E> extensionVersions = this.extensionsVersions.get(id);
        if (extensionVersions == null) {
            throw new ExtensionNotFoundException("Can't find extension with id [" + id + "]");
        }
        if (nb == 0 || offset >= extensionVersions.size()) {
            return new CollectionIterableResult<Version>(extensionVersions.size(), offset, Collections.emptyList());
        }
        ArrayList<Version> versions = new ArrayList<Version>(extensionVersions.size());
        for (Extension extension : extensionVersions) {
            versions.add(extension.getId().getVersion());
        }
        return RepositoryUtils.getIterableResult(offset, nb, versions);
    }

    @Override
    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        ExtensionQuery query = new ExtensionQuery(pattern);
        query.setOffset(offset);
        query.setLimit(nb);
        return this.search(query);
    }

    @Override
    public IterableResult<Extension> search(ExtensionQuery query) {
        Pattern patternMatcher = RepositoryUtils.createPatternMatcher(query.getQuery());
        HashSet<Extension> set = new HashSet<Extension>();
        ArrayList<Extension> result = new ArrayList<Extension>(this.extensionsVersions.size());
        for (List<E> versions : this.extensionsVersions.values()) {
            Extension extension = (Extension)versions.get(0);
            if (!RepositoryUtils.matches(patternMatcher, query.getFilters(), extension) || set.contains(extension)) continue;
            result.add(extension);
            set.add(extension);
        }
        RepositoryUtils.sort(result, query.getSortClauses());
        return RepositoryUtils.getIterableResult(query.getOffset(), query.getLimit(), result);
    }
}

