/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.xwiki.extension.ExtensionSupportPlan;
import org.xwiki.extension.ExtensionSupportPlans;
import org.xwiki.extension.ExtensionSupporter;
import org.xwiki.stability.Unstable;

@Unstable
public class DefaultExtensionSupportPlans
implements ExtensionSupportPlans {
    protected final List<ExtensionSupportPlan> supportPlans;
    protected final Map<ExtensionSupporter, List<ExtensionSupportPlan>> supporters;

    public DefaultExtensionSupportPlans(Collection<? extends ExtensionSupportPlan> supportPlans) {
        this.supportPlans = List.copyOf(supportPlans);
        this.supporters = this.supportPlans.stream().collect(Collectors.groupingBy(ExtensionSupportPlan::getSupporter, Collectors.mapping(p -> p, Collectors.toList())));
    }

    @Override
    public List<ExtensionSupportPlan> getSupportPlans() {
        return this.supportPlans;
    }

    @Override
    public Set<ExtensionSupporter> getSupporters() {
        return this.supporters.keySet();
    }

    @Override
    public List<ExtensionSupportPlan> getSupportPlans(ExtensionSupporter supporter) {
        return this.supporters.getOrDefault(supporter, List.of());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtensionSupportPlans) {
            ExtensionSupportPlans plans = (ExtensionSupportPlans)obj;
            return this.getSupportPlans().equals(plans.getSupportPlans());
        }
        return false;
    }

    public int hashCode() {
        return this.getSupportPlans().hashCode();
    }

    public String toString() {
        return this.supportPlans.toString();
    }
}

