/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.history.internal;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.history.ExtensionJobHistory;
import org.xwiki.extension.job.history.ExtensionJobHistoryRecord;
import org.xwiki.extension.job.history.QuestionRecorder;
import org.xwiki.extension.job.history.ReplayJobStatus;
import org.xwiki.job.Job;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.event.status.QuestionAnsweredEvent;
import org.xwiki.job.internal.AbstractJobStatus;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="ExtensionJobHistoryRecorder")
@Singleton
public class ExtensionJobHistoryRecorder
extends AbstractEventListener {
    public static final String NAME = "ExtensionJobHistoryRecorder";
    @Inject
    private ExtensionJobHistory history;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    private Map<String, Map<String, QuestionRecorder<Object>>> answers = new ConcurrentHashMap<String, Map<String, QuestionRecorder<Object>>>();

    public ExtensionJobHistoryRecorder() {
        super(NAME, new Event[]{new JobStartedEvent(), new QuestionAnsweredEvent(), new JobFinishedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof JobStartedEvent) {
            this.onJobStarted((Job)source);
        } else if (event instanceof QuestionAnsweredEvent) {
            this.onQuestionAnswered((JobStatus)source);
        } else if (event instanceof JobFinishedEvent) {
            this.onJobFinished((Job)source, data);
        }
    }

    private void onJobStarted(Job job) {
        if (!(job.getRequest() instanceof ExtensionRequest)) {
            return;
        }
        if (job.getStatus() instanceof AbstractJobStatus && this.isSubJob((AbstractJobStatus)job.getStatus())) {
            return;
        }
        String jobId = StringUtils.join((Iterable)job.getRequest().getId(), (char)'/');
        if (jobId != null) {
            this.answers.put(jobId, new HashMap());
        }
    }

    private <T extends AbstractJobStatus<?>> boolean isSubJob(T jobStatus) {
        return jobStatus.isSubJob() && !(jobStatus.getParentJobStatus() instanceof ReplayJobStatus);
    }

    private void onQuestionAnswered(JobStatus jobStatus) {
        QuestionRecorder<Object> questionRecorder;
        String jobId;
        Map<String, QuestionRecorder<Object>> jobAnswers;
        Object question = jobStatus.getQuestion();
        if (question != null && (jobAnswers = this.answers.get(jobId = StringUtils.join(this.getActualJobId(jobStatus), (char)'/'))) != null && (questionRecorder = this.getQuestionRecorder(question, jobAnswers)) != null) {
            questionRecorder.record(question);
        }
    }

    private List<String> getActualJobId(JobStatus jobStatus) {
        if (jobStatus instanceof ReplayJobStatus) {
            ExtensionJobHistoryRecord currentRecord = ((ReplayJobStatus)jobStatus).getCurrentRecord();
            return currentRecord != null ? currentRecord.getRequest().getId() : null;
        }
        return jobStatus.getRequest().getId();
    }

    private QuestionRecorder<Object> getQuestionRecorder(Object question, Map<String, QuestionRecorder<Object>> questionRecorders) {
        String questionType = question.getClass().getName();
        QuestionRecorder<Object> questionRecorder = questionRecorders.get(questionType);
        if (questionRecorder == null && (questionRecorder = this.getQuestionRecorder(question)) != null) {
            questionRecorders.put(questionType, questionRecorder);
        }
        return questionRecorder;
    }

    private <T> QuestionRecorder<T> getQuestionRecorder(T question) {
        DefaultParameterizedType questionRecorderType = new DefaultParameterizedType(null, QuestionRecorder.class, new Type[]{question.getClass()});
        try {
            return (QuestionRecorder)((ComponentManager)this.contextComponentManagerProvider.get()).getInstance((Type)questionRecorderType);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private void onJobFinished(Job job, Object data) {
        Map<String, QuestionRecorder<Object>> jobAnswers;
        String jobId = StringUtils.join((Iterable)job.getRequest().getId(), (char)'/');
        Map<String, QuestionRecorder<Object>> map = jobAnswers = jobId != null ? this.answers.remove(jobId) : null;
        if (data instanceof Throwable || jobAnswers == null) {
            return;
        }
        this.history.addRecord(new ExtensionJobHistoryRecord(job.getType(), (ExtensionRequest)job.getRequest(), jobAnswers, job.getStatus().getStartDate(), new Date()));
    }
}

