/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public final class PathUtils {
    private PathUtils() {
    }

    public static String encode(String str) {
        String encoded;
        try {
            encoded = URLEncoder.encode(str, "UTF-8").replace(".", "%2E").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            encoded = str;
        }
        return encoded;
    }

    private static URL fixURL(URL jarURL) {
        String jarURLString = jarURL.toExternalForm();
        if (StringUtils.contains((CharSequence)jarURLString, (int)32)) {
            jarURLString = jarURLString.replace(" ", "%20");
            try {
                return new URL(jarURLString);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return jarURL;
    }

    public static URL getExtensionURL(URL descriptorURL) throws IOException {
        URLConnection connection = descriptorURL.openConnection();
        if (connection instanceof JarURLConnection) {
            return PathUtils.fixURL(((JarURLConnection)connection).getJarFileURL());
        }
        return descriptorURL;
    }
}

