/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionRewriter;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.Request;

public abstract class AbstractExtensionRequest
extends AbstractRequest
implements ExtensionRequest {
    public static final String PROPERTY_EXTENSIONS = "extensions";
    public static final String PROPERTY_EXCLUDEDEXTENSIONS = "extensions.excluded";
    public static final String PROPERTY_NAMESPACES = "namespaces";
    public static final String PROPERTY_ROOTMODIFICATIONSALLOWED = "rootModificationsAllowed";
    public static final String PROPERTY_UNINSTALLALLOWED = "uninstallAllowed";
    public static final String PROPERTY_INSTALLEDIGNORED = "installedIgnored";
    public static final String PROPERTY_REWRITER = "rewriter";
    public static final String PROPERTY_COREEXTENSIONREPOSITORY = "coreExtensionRepository";
    private static final long serialVersionUID = 1L;

    public AbstractExtensionRequest() {
        this.setProperty(PROPERTY_EXTENSIONS, new ArrayList());
        this.setProperty(PROPERTY_EXCLUDEDEXTENSIONS, new HashSet());
    }

    public AbstractExtensionRequest(Request request) {
        super(request);
        Collection<ExtensionId> extensions = this.getExtensions();
        if (extensions == null) {
            this.setProperty(PROPERTY_EXTENSIONS, new ArrayList());
        }
    }

    @Override
    public Collection<ExtensionId> getExtensions() {
        return (Collection)this.getProperty(PROPERTY_EXTENSIONS);
    }

    public Collection<ExtensionId> getExcludedExtensions() {
        return (Collection)this.getProperty(PROPERTY_EXCLUDEDEXTENSIONS);
    }

    public Collection<ExtensionId> getCoreExtensions() {
        return (Collection)this.getProperty(PROPERTY_EXCLUDEDEXTENSIONS);
    }

    @Override
    public Collection<String> getNamespaces() {
        return (Collection)this.getProperty(PROPERTY_NAMESPACES);
    }

    @Override
    public boolean hasNamespaces() {
        Collection<String> namespaces = this.getNamespaces();
        return namespaces != null && !namespaces.isEmpty();
    }

    public void addExtension(ExtensionId extensionId) {
        this.getExtensions().add(extensionId);
    }

    public void addExtension(Extension extension) {
        this.getExtensions().add(new ExtensionExtensionId(extension));
    }

    public void addExcludedExtension(ExtensionId extensionId) {
        this.getExcludedExtensions().add(extensionId);
    }

    public void addCoreExtension(ExtensionId extensionId) {
        this.getCoreExtensions().add(extensionId);
    }

    public void addNamespace(String namespace) {
        Collection<String> namespaces = this.getNamespaces();
        if (namespaces == null) {
            namespaces = new ArrayList<String>();
            this.setProperty(PROPERTY_NAMESPACES, namespaces);
        }
        namespaces.add(namespace);
    }

    @Override
    public boolean isRootModificationsAllowed() {
        return (Boolean)this.getProperty(PROPERTY_ROOTMODIFICATIONSALLOWED, true);
    }

    public void setRootModificationsAllowed(boolean allowed) {
        this.setProperty(PROPERTY_ROOTMODIFICATIONSALLOWED, allowed);
    }

    @Transient
    public void setRewriter(ExtensionRewriter rewriter) {
        this.setProperty(PROPERTY_REWRITER, rewriter);
    }

    @Override
    @Transient
    public ExtensionRewriter getRewriter() {
        return (ExtensionRewriter)this.getProperty(PROPERTY_REWRITER);
    }

    @Transient
    public void setCoreExtensionRepository(CoreExtensionRepository repository) {
        this.setProperty(PROPERTY_COREEXTENSIONREPOSITORY, repository);
    }

    @Override
    @Transient
    public CoreExtensionRepository getCoreExtensionRepository() {
        return (CoreExtensionRepository)this.getProperty(PROPERTY_COREEXTENSIONREPOSITORY);
    }

    @Override
    public boolean isUninstallAllowed() {
        return (Boolean)this.getProperty(PROPERTY_UNINSTALLALLOWED, true);
    }

    public void setUninstallAllowed(boolean allowed) {
        this.setProperty(PROPERTY_UNINSTALLALLOWED, allowed);
    }

    @Override
    public boolean isInstalledIgnored() {
        return (Boolean)this.getProperty(PROPERTY_INSTALLEDIGNORED, false);
    }

    public void setInstalledIgnored(boolean ignored) {
        this.setProperty(PROPERTY_INSTALLEDIGNORED, ignored);
    }

    public class ExtensionExtensionId
    extends ExtensionId {
        private static final long serialVersionUID = 1L;
        private final Extension extension;

        public ExtensionExtensionId(Extension extension) {
            super(extension.getId().getId(), extension.getId().getVersion());
            this.extension = extension;
        }

        public Extension getExtension() {
            return this.extension;
        }
    }
}

