/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConversionException;
import org.xwiki.extension.ExtensionSupportPlan;
import org.xwiki.extension.ExtensionSupporter;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.converter.ExtensionConverterParser;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionSupportPlanConverter
extends AbstractConverter<ExtensionSupportPlan> {
    @Inject
    private ExtensionFactory factory;

    public static List<ExtensionSupportPlan> toExtensionSupportPlanList(Collection<?> values) throws MalformedURLException {
        return ExtensionSupportPlanConverter.toExtensionSupportPlanList(values, null);
    }

    public static List<ExtensionSupportPlan> toExtensionSupportPlanList(Collection<?> values, ExtensionFactory factory) throws MalformedURLException {
        ArrayList<ExtensionSupportPlan> list = new ArrayList<ExtensionSupportPlan>(values.size());
        for (Object value : values) {
            list.add(ExtensionSupportPlanConverter.toExtensionSupportPlan(value, factory));
        }
        return list;
    }

    public static ExtensionSupportPlan toExtensionSupportPlan(Object value) throws MalformedURLException {
        return ExtensionSupportPlanConverter.toExtensionSupportPlan(value, null);
    }

    public static ExtensionSupportPlan toExtensionSupportPlan(Object value, ExtensionFactory factory) throws MalformedURLException {
        if (value != null) {
            String valueString = value.toString();
            ExtensionConverterParser parser = new ExtensionConverterParser(valueString);
            String supporterName = parser.next(true);
            String supporterURL = parser.next(true);
            ExtensionSupporter suppoter = ExtensionFactory.getExtensionSupporter(factory, supporterName, StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{supporterURL}) ? new URL(supporterURL) : null);
            String name = parser.next(true);
            String url = parser.next(true);
            boolean paying = BooleanUtils.toBoolean((String)parser.next(false));
            return ExtensionFactory.getExtensionSupportPlan(factory, suppoter, name, url != null ? new URL(url) : null, paying);
        }
        return null;
    }

    public static String toString(ExtensionSupportPlan value) {
        return ExtensionConverterParser.toString(value.getSupporter().getName(), value.getSupporter().getURL(), value.getName(), value.getURL(), value.isPaying());
    }

    public static List<String> toStringList(Collection<ExtensionSupportPlan> values) {
        return values.stream().map(ExtensionSupportPlanConverter::toString).toList();
    }

    protected ExtensionSupportPlan convertToType(Type targetType, Object value) {
        try {
            return ExtensionSupportPlanConverter.toExtensionSupportPlan(value, this.factory);
        }
        catch (MalformedURLException e) {
            throw new ConversionException("Failed to parse the URL of the extension supporter in [" + value + "]", (Throwable)e);
        }
    }

    protected String convertToString(ExtensionSupportPlan value) {
        return ExtensionSupportPlanConverter.toString(value);
    }
}

