/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.converter.ExtensionConverterParser;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionAuthorConverter
extends AbstractConverter<ExtensionAuthor> {
    @Inject
    private ExtensionFactory factory;

    public static List<ExtensionAuthor> toExtensionAuthorList(Collection<?> values) {
        return ExtensionAuthorConverter.toExtensionAuthorList(values, null);
    }

    public static List<ExtensionAuthor> toExtensionAuthorList(Collection<?> values, ExtensionFactory factory) {
        ArrayList<ExtensionAuthor> list = new ArrayList<ExtensionAuthor>(values.size());
        for (Object value : values) {
            list.add(ExtensionAuthorConverter.toExtensionAuthor(value, factory));
        }
        return list;
    }

    public static ExtensionAuthor toExtensionAuthor(Object value) {
        return ExtensionAuthorConverter.toExtensionAuthor(value, null);
    }

    public static ExtensionAuthor toExtensionAuthor(Object value, ExtensionFactory factory) {
        if (value != null) {
            String valueString = value.toString();
            ExtensionConverterParser parser = new ExtensionConverterParser(valueString);
            String name = parser.next(true);
            String url = parser.next(false);
            return ExtensionFactory.getExtensionAuthor(factory, name, url);
        }
        return null;
    }

    public static String toString(ExtensionAuthor value) {
        return ExtensionConverterParser.toString(value.getName(), value.getURLString());
    }

    public static List<String> toStringList(Collection<ExtensionAuthor> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionAuthor value : values) {
            list.add(ExtensionAuthorConverter.toString(value));
        }
        return list;
    }

    protected ExtensionAuthor convertToType(Type targetType, Object value) {
        return ExtensionAuthorConverter.toExtensionAuthor(value, this.factory);
    }

    protected String convertToString(ExtensionAuthor value) {
        return ExtensionAuthorConverter.toString(value);
    }
}

