/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;

public class DefaultExtensionRepositoryDescriptor
implements ExtensionRepositoryDescriptor {
    private final String id;
    private final String type;
    private final URI uri;
    private Map<String, String> properties = new HashMap<String, String>();
    private transient int hashCode;

    public DefaultExtensionRepositoryDescriptor(ExtensionRepositoryDescriptor descriptor) {
        this(descriptor.getId(), descriptor.getType(), descriptor.getURI());
        this.setProperties(descriptor.getProperties());
    }

    public DefaultExtensionRepositoryDescriptor(String id) {
        this(id, null, null);
    }

    public DefaultExtensionRepositoryDescriptor(String id, String type, URI uri) {
        this.id = id;
        this.type = type;
        this.uri = uri;
    }

    public DefaultExtensionRepositoryDescriptor(String id, String type, URI uri, Map<String, String> properties) {
        this.id = id;
        this.type = type;
        this.uri = uri;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void putProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtensionRepositoryDescriptor) {
            ExtensionRepositoryDescriptor repository = (ExtensionRepositoryDescriptor)obj;
            return Objects.equals(this.getId(), repository.getId()) && Objects.equals(this.getType(), repository.getType()) && Objects.equals(this.getURI(), repository.getURI()) && Objects.equals(this.getProperties(), repository.getProperties());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.getId());
            builder.append((Object)this.getType());
            builder.append((Object)this.getURI());
            builder.append(this.getProperties());
            this.hashCode = builder.toHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getId() + ":" + this.getType() + ":" + String.valueOf(this.getURI());
    }
}

