/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension;

/**
 * Informations related to a component provided by an extension.
 *
 * @version $Id: 4d637b31764f1450bf911468bf7576754e5cec2a $
 * @since 13.3RC1
 */
public interface ExtensionComponent
{
    /**
     * @return the class of the component role as String
     */
    String getRoleType();

    /**
     * @return the hint of the component role
     */
    String getRoleHint();

    /**
     * The same type can be represented as several different {@link String} so it's recommended to use this method when
     * you want to compare a type name with this extension component type.
     * 
     * @param type the type name to compare
     * @return true of the passed type name is equals to the component one
     */
    boolean equalRoleType(String type);
}
