/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.job.internal;

import javax.inject.Named;

import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;

/**
 * @version $Id: 7f7acf840be6d9dc683b44a0b92534e1d9f0a9fe $
 * @since 9.4RC1
 */
@Component
@Named(DependenciesJob.JOBTYPE)
public class DependenciesJob extends InstallPlanJob
{
    /**
     * The id of the job.
     */
    public static final String JOBTYPE = "dependencies";

    @Override
    protected void checkTypeInstall(Extension extension, String namespace) throws InstallException
    {
        // Always allowed
    }

    @Override
    protected boolean isNamespaceAllowed(Extension extension, String namespace)
    {
        // Always allowed
        return true;
    }
}
