/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="ExtensionApplicationStartedListener")
public class ExtensionApplicationStartedListener
implements EventListener {
    private static final List<Event> EVENTS = Collections.singletonList(new ApplicationStartedEvent());
    @Inject
    private Provider<CoreExtensionRepository> coreExtensionsProvider;
    @Inject
    private Provider<ExtensionManagerConfiguration> configuration;
    @Inject
    private Provider<ExtensionRepositoryManager> repositoryManagerProvider;
    @Inject
    private Provider<ExtensionInitializer> extensionInitializer;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return "ExtensionApplicationStartedListener";
    }

    public void onEvent(Event arg0, Object arg1, Object arg2) {
        this.extensionInitializer.get();
        CoreExtensionRepository coreExtensions = (CoreExtensionRepository)this.coreExtensionsProvider.get();
        if (coreExtensions instanceof DefaultCoreExtensionRepository && ((ExtensionManagerConfiguration)this.configuration.get()).resolveCoreExtensions() && !((ExtensionRepositoryManager)this.repositoryManagerProvider.get()).getRepositories().isEmpty()) {
            ((DefaultCoreExtensionRepository)coreExtensions).updateExtensions();
        }
    }
}

