/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionComponent;
import org.xwiki.extension.ExtensionComponent;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionComponentConverter
extends AbstractConverter<ExtensionComponent> {
    private static int countBackslashes(String str, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (str.charAt(i) == '\\') continue;
            return index - i - 1;
        }
        return index;
    }

    public static List<ExtensionComponent> toExtensionComponentList(Collection<?> values) {
        ArrayList<ExtensionComponent> list = new ArrayList<ExtensionComponent>(values.size());
        for (Object value : values) {
            list.add(ExtensionComponentConverter.toExtensionComponent(value));
        }
        return list;
    }

    public static ExtensionComponent toExtensionComponent(Object value) {
        if (value != null) {
            String valueString = value.toString();
            return ExtensionComponentConverter.toExtensionComponent(valueString, valueString.length() - 1);
        }
        return null;
    }

    private static ExtensionComponent toExtensionComponent(String value, int end) {
        String roleHint;
        String roleType;
        String valueString = value;
        int index = valueString.indexOf(47);
        if (index > 0 && index < end) {
            int backslashes = ExtensionComponentConverter.countBackslashes(valueString, index);
            if (backslashes > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(valueString.substring(0, index - backslashes));
                builder.append(StringUtils.repeat((char)'\\', (int)(backslashes / 2)));
                builder.append(valueString.substring(index));
                valueString = builder.toString();
                index -= backslashes - backslashes / 2;
                if (backslashes % 2 == 1) {
                    return ExtensionComponentConverter.toExtensionComponent(valueString, index - backslashes - 1);
                }
            }
            roleType = valueString.substring(0, index);
            roleHint = valueString.substring(index + 1);
        } else {
            roleType = valueString;
            roleHint = null;
        }
        return new DefaultExtensionComponent(roleType, roleHint);
    }

    public static String toString(ExtensionComponent value) {
        StringBuilder builder = new StringBuilder();
        builder.append(value.getRoleType());
        if (value.getRoleHint() != null) {
            builder.append('/');
            builder.append(value.getRoleHint());
        }
        return builder.toString();
    }

    public static List<String> toStringList(Collection<ExtensionComponent> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionComponent value : values) {
            list.add(ExtensionComponentConverter.toString(value));
        }
        return list;
    }

    protected ExtensionComponent convertToType(Type targetType, Object value) {
        return ExtensionComponentConverter.toExtensionComponent(value);
    }

    protected String convertToString(ExtensionComponent value) {
        return ExtensionComponentConverter.toString(value);
    }
}

