/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.ExtensionComponent;

public class DefaultExtensionComponent
implements ExtensionComponent {
    private static final Pattern WHITE_SPACES_PATTEN = Pattern.compile("\\s+");
    private final String roleType;
    private final String roleHint;

    public DefaultExtensionComponent(String roleType, String roleHint) {
        this.roleType = DefaultExtensionComponent.toCanonicalComponentType(roleType);
        this.roleHint = roleHint;
    }

    public static String toCanonicalComponentType(String componentType) {
        return componentType != null ? WHITE_SPACES_PATTEN.matcher(componentType).replaceAll("") : null;
    }

    @Override
    public String getRoleType() {
        return this.roleType;
    }

    @Override
    public String getRoleHint() {
        return this.roleHint;
    }

    @Override
    public boolean equalRoleType(String type) {
        return this.getRoleType().equals(DefaultExtensionComponent.toCanonicalComponentType(type));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExtensionComponent) {
            ExtensionComponent otherAuthor = (ExtensionComponent)obj;
            return StringUtils.equals((CharSequence)this.getRoleType(), (CharSequence)otherAuthor.getRoleType()) && StringUtils.equals((CharSequence)this.getRoleHint(), (CharSequence)otherAuthor.getRoleHint());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getRoleType());
        builder.append((Object)this.getRoleHint());
        return builder.toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRoleType());
        if (this.getRoleHint() != null) {
            builder.append('(');
            builder.append(this.getRoleHint());
            builder.append(')');
        }
        return builder.toString();
    }
}

