/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.Extension;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.internal.SortClauseComparator;
import org.xwiki.extension.repository.result.AggregatedIterableResult;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.AdvancedSearchable;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;

public final class RepositoryUtils {
    public static final String SEARCH_PATTERN_SUFFIXNPREFIX = ".*";
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryUtils.class);

    private RepositoryUtils() {
    }

    public static <E extends Extension> CollectionIterableResult<E> searchInCollection(String pattern, int offset, int nb, Collection<E> extensions) {
        return RepositoryUtils.searchInCollection(pattern, offset, nb, extensions, false);
    }

    public static <E extends Extension> CollectionIterableResult<E> searchInCollection(String pattern, int offset, int nb, Collection<E> extensions, boolean forceUnique) {
        ExtensionQuery query = new ExtensionQuery(pattern);
        query.setOffset(offset);
        query.setLimit(nb);
        return RepositoryUtils.searchInCollection(query, extensions, forceUnique);
    }

    public static <E extends Extension> CollectionIterableResult<E> searchInCollection(ExtensionQuery query, Collection<E> extensions, boolean forceUnique) {
        List<E> result = StringUtils.isEmpty((CharSequence)query.getQuery()) ? (extensions instanceof List ? (List<E>)extensions : new ArrayList<E>(extensions)) : RepositoryUtils.filter(query.getQuery(), query.getFilters(), extensions, forceUnique);
        RepositoryUtils.sort(result, query.getSortClauses());
        return RepositoryUtils.getIterableResult(query.getOffset(), query.getLimit(), result);
    }

    public static <E> CollectionIterableResult<E> getIterableResult(int offset, int nb, Collection<E> elements) {
        if (nb == 0 || offset >= elements.size()) {
            return new CollectionIterableResult(elements.size(), offset, Collections.emptyList());
        }
        ArrayList<E> list = elements instanceof List ? (ArrayList<E>)elements : new ArrayList<E>(elements);
        return RepositoryUtils.getIterableResultFromList(offset, nb, list);
    }

    private static <E> CollectionIterableResult<E> getIterableResultFromList(int offset, int nb, List<E> elements) {
        int toIndex;
        int fromIndex = offset;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (nb > 0) {
            toIndex = nb + fromIndex;
            if (toIndex > elements.size()) {
                toIndex = elements.size();
            }
        } else {
            toIndex = elements.size();
        }
        return new CollectionIterableResult<E>(elements.size(), offset, elements.subList(fromIndex, toIndex));
    }

    private static <E extends Extension> List<E> filter(String pattern, Collection<ExtensionQuery.Filter> filters, Collection<E> extensions, boolean forceUnique) {
        ArrayList<Extension> result = new ArrayList<Extension>(extensions.size());
        Pattern patternMatcher = Pattern.compile(SEARCH_PATTERN_SUFFIXNPREFIX + pattern.toLowerCase() + SEARCH_PATTERN_SUFFIXNPREFIX);
        for (Extension extension : extensions) {
            if (!RepositoryUtils.matches(patternMatcher, filters, extension)) continue;
            result.add(extension);
        }
        if (forceUnique && result.size() > 1) {
            result = new ArrayList(new LinkedHashSet(result));
        }
        return result;
    }

    public static boolean matches(Pattern patternMatcher, Collection<ExtensionQuery.Filter> filters, Extension extension) {
        if (RepositoryUtils.matches(patternMatcher, extension.getId().getId(), extension.getDescription(), extension.getSummary(), extension.getName(), ExtensionIdConverter.toStringList(extension.getExtensionFeatures()))) {
            for (ExtensionQuery.Filter filter : filters) {
                if (RepositoryUtils.matches(filter, extension)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean matches(Collection<ExtensionQuery.Filter> filters, Extension extension) {
        if (filters != null) {
            for (ExtensionQuery.Filter filter : filters) {
                if (RepositoryUtils.matches(filter, extension)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean matches(ExtensionQuery.Filter filter, Extension extension) {
        return RepositoryUtils.matches(filter, extension.get(filter.getField()));
    }

    public static boolean matches(ExtensionQuery.Filter filter, Object element) {
        Pattern patternMatcher;
        if (element == null) {
            return filter.getValue() == null;
        }
        if (filter.getValue() == null) {
            return false;
        }
        String filterValue = String.valueOf(filter.getValue());
        String elementValue = String.valueOf(element);
        return filter.getComparison() == ExtensionQuery.COMPARISON.MATCH ? RepositoryUtils.matches(patternMatcher = RepositoryUtils.createPatternMatcher(filterValue), (Object)elementValue) : filter.getComparison() == ExtensionQuery.COMPARISON.EQUAL && filterValue.equals(elementValue);
    }

    public static boolean matches(Pattern patternMatcher, Object ... elements) {
        if (patternMatcher == null) {
            return true;
        }
        for (Object element : elements) {
            if (!RepositoryUtils.matches(patternMatcher, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Pattern patternMatcher, Object element) {
        return element != null && patternMatcher.matcher(element.toString().toLowerCase()).matches();
    }

    public static Pattern createPatternMatcher(String pattern) {
        return StringUtils.isEmpty((CharSequence)pattern) ? null : Pattern.compile(SEARCH_PATTERN_SUFFIXNPREFIX + Pattern.quote(pattern.toLowerCase()) + SEARCH_PATTERN_SUFFIXNPREFIX);
    }

    public static void sort(List<? extends Extension> extensions, Collection<ExtensionQuery.SortClause> sortClauses) {
        Collections.sort(extensions, new SortClauseComparator(sortClauses));
    }

    public static <E extends Extension> IterableResult<E> appendSearchResults(IterableResult<E> previousSearchResult, IterableResult<E> result) {
        AggregatedIterableResult<E> newResult;
        if (previousSearchResult instanceof AggregatedIterableResult) {
            newResult = (AggregatedIterableResult<E>)previousSearchResult;
        } else if (previousSearchResult != null) {
            newResult = new AggregatedIterableResult<E>(previousSearchResult.getOffset());
            newResult.addSearchResult(previousSearchResult);
        } else {
            return result;
        }
        newResult.addSearchResult(result);
        return newResult;
    }

    public static IterableResult<Extension> search(ExtensionQuery query, Iterable<ExtensionRepository> repositories) throws SearchException {
        IterableResult<Extension> searchResult = null;
        int currentOffset = query.getOffset() > 0 ? query.getOffset() : 0;
        int currentNb = query.getLimit();
        for (ExtensionRepository repository : repositories) {
            try {
                if ((searchResult = RepositoryUtils.search(repository, query, currentOffset, currentNb, searchResult)) == null) continue;
                if (currentOffset > 0 && (currentOffset = query.getOffset() - searchResult.getTotalHits()) < 0) {
                    currentOffset = 0;
                }
                if (currentNb <= 0 || (currentNb = query.getLimit() - searchResult.getSize()) >= 0) continue;
                currentNb = 0;
            }
            catch (Exception e) {
                LOGGER.error("Failed to search on repository [{}] with query [{}]. Ignore and go to next repository.", new Object[]{repository.getDescriptor().toString(), query, e});
            }
        }
        return searchResult != null ? searchResult : new CollectionIterableResult<Extension>(0, query.getOffset(), Collections.emptyList());
    }

    private static IterableResult<Extension> search(ExtensionRepository repository, ExtensionQuery query, int currentOffset, int currentNb, IterableResult<Extension> previousSearchResult) throws SearchException {
        ExtensionQuery customQuery = query;
        if (currentOffset != customQuery.getOffset() && currentNb != customQuery.getLimit()) {
            customQuery = new ExtensionQuery(query);
            customQuery.setOffset(currentOffset);
            customQuery.setLimit(currentNb);
        }
        return RepositoryUtils.search(repository, customQuery, previousSearchResult);
    }

    public static IterableResult<Extension> search(ExtensionRepository repository, ExtensionQuery query, IterableResult<Extension> previousSearchResult) throws SearchException {
        IterableResult<Extension> result;
        if (repository instanceof Searchable) {
            if (repository instanceof AdvancedSearchable) {
                AdvancedSearchable searchableRepository = (AdvancedSearchable)((Object)repository);
                result = searchableRepository.search(query);
            } else {
                Searchable searchableRepository = (Searchable)((Object)repository);
                result = searchableRepository.search(query.getQuery(), query.getOffset(), query.getLimit());
            }
            if (previousSearchResult != null) {
                result = RepositoryUtils.appendSearchResults(previousSearchResult, result);
            }
        } else {
            result = previousSearchResult;
        }
        return result;
    }
}

