/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.result;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.xwiki.extension.repository.result.IterableResult;

public class AggregatedIterableResult<T>
implements IterableResult<T> {
    private List<IterableResult<T>> results = new ArrayList<IterableResult<T>>();
    private int offset;
    private Integer totalHits;
    private Integer size;

    public AggregatedIterableResult(int offset) {
        this.offset = offset;
    }

    public void addSearchResult(IterableResult<T> result) {
        this.results.add(result);
        this.totalHits = null;
        this.size = null;
    }

    @Override
    public Iterator<T> iterator() {
        IteratorChain iterator = new IteratorChain();
        for (IterableResult<T> result : this.results) {
            iterator.addIterator(result.iterator());
        }
        return iterator;
    }

    @Override
    public int getTotalHits() {
        if (this.totalHits == null) {
            this.totalHits = 0;
            for (IterableResult<T> result : this.results) {
                AggregatedIterableResult aggregatedIterableResult = this;
                Integer.valueOf(aggregatedIterableResult.totalHits + result.getTotalHits());
                aggregatedIterableResult.totalHits = aggregatedIterableResult.totalHits;
            }
        }
        return this.totalHits;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        if (this.size == null) {
            this.size = 0;
            for (IterableResult<T> result : this.results) {
                AggregatedIterableResult aggregatedIterableResult = this;
                Integer.valueOf(aggregatedIterableResult.size + result.getTotalHits());
                aggregatedIterableResult.size = aggregatedIterableResult.size;
            }
        }
        return this.size;
    }
}

