/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionIdConverter
extends AbstractConverter<ExtensionId> {
    @Inject
    private ExtensionFactory factory;

    private static int countBackslashes(String str, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (str.charAt(i) == '\\') continue;
            return index - i - 1;
        }
        return index;
    }

    public static List<ExtensionId> toExtensionIdList(Collection<?> values, Version defaultVersion) {
        return ExtensionIdConverter.toExtensionIdList(values, defaultVersion, null);
    }

    public static List<ExtensionId> toExtensionIdList(Collection<?> values, Version defaultVersion, ExtensionFactory factory) {
        ArrayList<ExtensionId> list = new ArrayList<ExtensionId>(values.size());
        for (Object value : values) {
            list.add(ExtensionIdConverter.toExtensionId(value, defaultVersion, factory));
        }
        return list;
    }

    public static ExtensionId toExtensionId(Object value, Version defaultVersion) {
        return ExtensionIdConverter.toExtensionId(value, defaultVersion, null);
    }

    public static ExtensionId toExtensionId(Object value, Version defaultVersion, ExtensionFactory factory) {
        if (value != null) {
            String valueString = value.toString();
            return ExtensionIdConverter.toExtensionId(valueString, valueString.length() - 1, defaultVersion, factory);
        }
        return null;
    }

    private static ExtensionId toExtensionId(String value, int end, Version defaultVersion, ExtensionFactory factory) {
        Version version;
        String id;
        String valueString = value;
        int index = valueString.lastIndexOf(47);
        if (index > 0 && index < end) {
            int backslashes = ExtensionIdConverter.countBackslashes(valueString, index);
            if (backslashes > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(valueString.substring(0, index - backslashes));
                builder.append(StringUtils.repeat((char)'\\', (int)(backslashes / 2)));
                builder.append(valueString.substring(index));
                valueString = builder.toString();
                index -= backslashes - backslashes / 2;
                if (backslashes % 2 == 1) {
                    return ExtensionIdConverter.toExtensionId(valueString, index - backslashes - 1, defaultVersion, factory);
                }
            }
            id = valueString.substring(0, index);
            String versionString = valueString.substring(index + 1);
            version = factory != null ? factory.getVersion(versionString) : new DefaultVersion(versionString);
        } else {
            id = valueString;
            version = defaultVersion;
        }
        return new ExtensionId(id, version);
    }

    public static String toString(ExtensionId value) {
        StringBuilder builder = new StringBuilder();
        builder.append(value.getId().replace("\\", "\\\\").replace("/", "\\/"));
        if (value.getVersion() != null) {
            builder.append('/');
            builder.append(value.getVersion());
        }
        return builder.toString();
    }

    public static List<String> toStringList(Collection<ExtensionId> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionId value : values) {
            list.add(ExtensionIdConverter.toString(value));
        }
        return list;
    }

    protected ExtensionId convertToType(Type targetType, Object value) {
        return ExtensionIdConverter.toExtensionId(value, null, this.factory);
    }

    protected String convertToString(ExtensionId value) {
        return ExtensionIdConverter.toString(value);
    }
}

