/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.MutableExtension;
import org.xwiki.extension.RemoteExtension;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.rating.RatingExtension;
import org.xwiki.extension.version.IncompatibleVersionConstraintException;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.wrap.WrappingCoreExtension;
import org.xwiki.extension.wrap.WrappingExtension;
import org.xwiki.extension.wrap.WrappingInstalledExtension;
import org.xwiki.extension.wrap.WrappingLocalExtension;
import org.xwiki.extension.wrap.WrappingRatingExtension;
import org.xwiki.extension.wrap.WrappingRemoteExtension;
import org.xwiki.properties.converter.ConversionException;

public final class ExtensionUtils {
    private ExtensionUtils() {
    }

    public static ExtensionDependency getRecommendedDependency(ExtensionDependency dependency, ExtensionManagerConfiguration configuration, ExtensionFactory factory) {
        VersionConstraint recommendedVersionConstraint = configuration.getRecomendedVersionConstraint(dependency.getId(), dependency.getVersionConstraint());
        if (recommendedVersionConstraint != null) {
            try {
                recommendedVersionConstraint = dependency.getVersionConstraint().merge(recommendedVersionConstraint);
                return factory.getExtensionDependency(dependency.getId(), recommendedVersionConstraint, dependency.isOptional(), dependency.getProperties());
            }
            catch (IncompatibleVersionConstraintException incompatibleVersionConstraintException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ExtensionDependency getDependency(ExtensionDependency dependency, Map<String, ExtensionDependency> managedDependencies, Extension extension) {
        ExtensionDependency managedDependency = managedDependencies.get(dependency.getId());
        if (managedDependency == null && dependency.getVersionConstraint() == null) {
            for (ExtensionDependency extensionManagedDependency : extension.getManagedDependencies()) {
                if (!extensionManagedDependency.getId().equals(dependency.getId())) continue;
                managedDependency = extensionManagedDependency;
            }
        }
        if (managedDependency != null) {
            return new DefaultExtensionDependency(dependency, managedDependency.getVersionConstraint());
        }
        return dependency;
    }

    public static Map<String, ExtensionDependency> append(Map<String, ExtensionDependency> managedDependencies, Extension extension) {
        HashMap<String, ExtensionDependency> newManagedDependencies = managedDependencies != null ? new HashMap<String, ExtensionDependency>(managedDependencies) : new HashMap();
        for (ExtensionDependency dependency : extension.getManagedDependencies()) {
            newManagedDependencies.put(dependency.getId(), dependency);
        }
        return newManagedDependencies;
    }

    public static <T> Set<T> append(Set<T> readonly, T obj) {
        HashSet<T> writable = readonly != null ? new HashSet<T>(readonly) : new HashSet();
        writable.add(obj);
        return writable;
    }

    public static <T> T importProperty(MutableExtension extension, String propertySuffix) {
        return extension.removeProperty("xwiki.extension." + propertySuffix);
    }

    public static String importProperty(MutableExtension extension, String propertySuffix, String def) {
        return StringUtils.defaultString((String)((String)ExtensionUtils.importProperty(extension, propertySuffix)), (String)def);
    }

    public static Collection<String> importProperty(MutableExtension extension, String propertySuffix, Collection<String> def) {
        Object obj = ExtensionUtils.importProperty(extension, propertySuffix);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof String[]) {
            return Arrays.asList((String[])obj);
        }
        return ExtensionUtils.importPropertyStringList(obj.toString(), true);
    }

    public static List<String> importPropertyStringList(String str, boolean trim) {
        try {
            int ttype;
            String cleanedString = str;
            if (trim) {
                cleanedString = cleanedString.trim();
            }
            StreamTokenizer st = new StreamTokenizer(new StringReader(cleanedString));
            st.ordinaryChars(0, 255);
            st.wordChars(0, 255);
            st.quoteChar(34);
            st.quoteChar(39);
            st.whitespaceChars(44, 44);
            st.whitespaceChars(32, 32);
            st.whitespaceChars(9, 9);
            st.whitespaceChars(10, 10);
            st.whitespaceChars(13, 13);
            ArrayList<String> collection = new ArrayList<String>();
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                collection.add(st.sval);
            }
            if (ttype != -1) {
                throw new ConversionException("Encountered token of type " + ttype + " parsing elements.");
            }
            return collection;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public static <T extends Extension> WrappingExtension<T> wrap(Extension extension) {
        WrappingExtension wrapper = extension instanceof CoreExtension ? new WrappingCoreExtension<CoreExtension>((CoreExtension)extension) : (extension instanceof InstalledExtension ? new WrappingInstalledExtension<InstalledExtension>((InstalledExtension)extension) : (extension instanceof LocalExtension ? new WrappingLocalExtension<LocalExtension>((LocalExtension)extension) : (extension instanceof RatingExtension ? new WrappingRatingExtension<RatingExtension>((RatingExtension)extension) : (extension instanceof RemoteExtension ? new WrappingRemoteExtension<RemoteExtension>((RemoteExtension)extension) : new WrappingExtension<Extension>(extension)))));
        return wrapper;
    }
}

