/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.internal.AbstractEnvironment;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;

@Component
@Singleton
public class ServletEnvironment
extends AbstractEnvironment {
    private ServletContext jakartaServletContext;
    private javax.servlet.ServletContext javaxServletContext;

    public void setServletContext(javax.servlet.ServletContext servletContext) {
        this.javaxServletContext = servletContext;
        this.jakartaServletContext = JakartaServletBridge.toJakarta((javax.servlet.ServletContext)servletContext);
    }

    public void setServletContext(ServletContext servletContext) {
        this.jakartaServletContext = servletContext;
    }

    @Deprecated(since="17.0.0RC1")
    public javax.servlet.ServletContext getServletContext() {
        if (this.javaxServletContext == null) {
            this.javaxServletContext = JakartaServletBridge.toJavax((ServletContext)this.getJakartaServletContext());
        }
        return this.javaxServletContext;
    }

    public ServletContext getJakartaServletContext() {
        if (this.jakartaServletContext == null) {
            throw new RuntimeException("The Servlet Environment has not been properly initialized (The Servlet Context is not set)");
        }
        return this.jakartaServletContext;
    }

    public InputStream getResourceAsStream(String resourceName) {
        return this.getJakartaServletContext().getResourceAsStream(resourceName);
    }

    public URL getResource(String resourceName) {
        URL url;
        try {
            url = this.getJakartaServletContext().getResource(resourceName);
            if (url != null) {
                url = url.toURI().normalize().toURL();
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            url = null;
            this.logger.warn("Error getting resource [{}] because of invalid path format. Reason: [{}]", (Object)resourceName, (Object)e.getMessage());
        }
        return url;
    }

    protected String getTemporaryDirectoryName() {
        String tmpDirectory = super.getTemporaryDirectoryName();
        try {
            if (tmpDirectory == null) {
                File tempDir = (File)this.getJakartaServletContext().getAttribute("jakarta.servlet.context.tempdir");
                return tempDir == null ? null : tempDir.getCanonicalPath();
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to get Servlet temporary directory due to error [{}], falling back on the default System temporary directory.", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        return tmpDirectory;
    }
}

