/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheControl;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.environment.internal.AbstractEnvironment;

@Component
@Singleton
public class ServletEnvironment
extends AbstractEnvironment {
    private ServletContext servletContext;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private CacheControl cacheControl;
    private Cache<Optional<URL>> resourceURLCache;
    private final AtomicBoolean cacheInitializing = new AtomicBoolean();

    private Cache<Optional<URL>> getResourceURLCache() {
        if (this.resourceURLCache == null && this.cacheInitializing.compareAndSet(false, true)) {
            try {
                if (this.resourceURLCache == null) {
                    CacheManager cacheManager = (CacheManager)this.componentManager.getInstance(CacheManager.class);
                    this.resourceURLCache = cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("environment.servlet.resourceURLCache", 10000));
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to initialize resource URL cache.", (Throwable)e);
            }
            finally {
                this.cacheInitializing.set(false);
            }
        }
        return this.resourceURLCache;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            throw new RuntimeException("The Servlet Environment has not been properly initialized (The Servlet Context is not set)");
        }
        return this.servletContext;
    }

    public InputStream getResourceAsStream(String resourceName) {
        return this.getServletContext().getResourceAsStream(resourceName);
    }

    public URL getResource(String resourceName) {
        Optional cachedURL;
        Cache<Optional<URL>> cache = this.getResourceURLCache();
        if (cache != null && this.cacheControl.isCacheReadAllowed() && (cachedURL = (Optional)cache.get(resourceName)) != null) {
            return cachedURL.orElse(null);
        }
        URL url = this.getResourceInternal(resourceName);
        if (cache != null) {
            cache.set(resourceName, Optional.ofNullable(url));
        }
        return url;
    }

    private URL getResourceInternal(String resourceName) {
        URL url;
        try {
            url = this.getServletContext().getResource(resourceName);
            if (url != null) {
                url = url.toURI().normalize().toURL();
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            url = null;
            this.logger.warn("Error getting resource [{}] because of invalid path format. Reason: [{}]", (Object)resourceName, (Object)e.getMessage());
        }
        return url;
    }

    protected String getTemporaryDirectoryName() {
        String tmpDirectory = super.getTemporaryDirectoryName();
        try {
            if (tmpDirectory == null) {
                File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
                return tempDir == null ? null : tempDir.getCanonicalPath();
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to get Servlet temporary directory due to error [{}], falling back on the default System temporary directory.", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        return tmpDirectory;
    }
}

