/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.xml.StringSplitter;

@Component
@Singleton
@Named(value="word")
public class WordStringSplitter
implements StringSplitter {
    private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");

    @Override
    public List<Object> split(String text) {
        return Arrays.stream(WHITE_SPACE.split(text)).collect(Collectors.toList());
    }

    @Override
    public String join(List<Object> words) {
        return words.stream().map(Object::toString).collect(Collectors.joining(" "));
    }
}

