/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.xml.internal.AbstractXMLDiffMarker;
import org.xwiki.diff.xml.internal.XMLDiffUtils;

@Component
@Singleton
@Named(value="html")
public class HTMLDiffMarker
extends AbstractXMLDiffMarker {
    static final String DIFF_BLOCK_ATTRIBUTE = "data-xwiki-html-diff-block";
    private static final List<String> IGNORED_TAGS = Arrays.asList("");
    private static final List<String> ACCEPTED_ATTRIBUTES = Arrays.asList("align", "background", "bgcolor", "border", "cite", "class", "color", "cols", "colspan", "controls", "coords", "data", "dir", "disabled", "height", "hidden", "high", "icon", "label", "low", "multiple", "placeholder", "rows", "rowspan", "shape", "size", "src", "start", "style", "summary", "type", "value", "width", "wrap");
    private static final List<String> BLOCK_ELEMENTS_WE_CAN_DUPLICATE = Arrays.asList("audio", "video", "figure", "figcaption", "ol", "ul", "li", "dl", "dd", "dt", "table", "tr", "address", "div", "p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "blockquote", "form", "fieldset", "hr", "article", "aside", "details", "footer", "header", "main", "nav", "section", "center");
    private static final List<String> TAGS_THAT_DONT_ACCEPT_INLINE_MARKER = Arrays.asList("html", "head", "base", "meta", "title", "link", "script", "style", "br", "hr", "img", "picture", "embed", "iframe", "area", "param", "source", "track", "input", "textarea", "select", "optgroup", "option", "dl", "ol", "ul", "table", "thead", "tfoot", "tbody", "colgroup", "col", "tr");
    private static final String DELETED = "deleted";
    private static final String INSERTED = "inserted";
    private static final String RIGHT_BLOCK = "xwiki-html-diff-block-right";

    @Override
    protected boolean acceptChangesFor(Element element) {
        return !IGNORED_TAGS.contains(element.getNodeName());
    }

    @Override
    protected boolean acceptChangesFor(Attr attribute) {
        return ACCEPTED_ATTRIBUTES.contains(attribute.getName());
    }

    @Override
    protected boolean acceptAsDiffBlock(Element element) {
        return BLOCK_ELEMENTS_WE_CAN_DUPLICATE.contains(element.getNodeName());
    }

    @Override
    protected void markDiffBlock(Element element) {
        element.setAttribute(DIFF_BLOCK_ATTRIBUTE, DELETED);
    }

    @Override
    protected void unmarkDiffBlock(Element element) {
        element.removeAttribute(DIFF_BLOCK_ATTRIBUTE);
    }

    @Override
    protected boolean isMarkedAsDiffBlock(Element element) {
        return element.hasAttribute(DIFF_BLOCK_ATTRIBUTE);
    }

    @Override
    protected boolean supportsInlineMarkerElements(Element parent) {
        return !TAGS_THAT_DONT_ACCEPT_INLINE_MARKER.contains(parent.getNodeName());
    }

    @Override
    protected String getInlineMarkerElementName() {
        return "span";
    }

    @Override
    protected void markElementModified(Element element, boolean deleted) {
        String attribute = element.hasAttribute(DIFF_BLOCK_ATTRIBUTE) ? DIFF_BLOCK_ATTRIBUTE : "data-xwiki-html-diff";
        this.markElementModified(element, attribute, deleted);
    }

    private void markElementModified(Element element, String markerAttribute, boolean deleted) {
        element.setAttribute(markerAttribute, deleted ? DELETED : INSERTED);
    }

    @Override
    protected Node getOrCreateRightNode(Node left) {
        if (left.getNodeType() == 2) {
            Element elementRight = (Element)this.getOrCreateRightNode(((Attr)left).getOwnerElement());
            return elementRight.getAttributeNode(left.getNodeName());
        }
        if (left.getNodeType() == 1 && this.isMarkedAsDiffBlock((Element)left)) {
            Element diffBlockLeft = (Element)left;
            Element diffBlockRight = (Element)diffBlockLeft.getUserData(RIGHT_BLOCK);
            if (diffBlockRight == null) {
                diffBlockRight = (Element)diffBlockLeft.cloneNode(true);
                this.markElementModified(diffBlockLeft, DIFF_BLOCK_ATTRIBUTE, true);
                this.markElementModified(diffBlockRight, DIFF_BLOCK_ATTRIBUTE, false);
                diffBlockLeft.setUserData(RIGHT_BLOCK, diffBlockRight, null);
            }
            return diffBlockRight;
        }
        Node parentLeft = left.getParentNode();
        if (parentLeft != null) {
            Node parentRight = this.getOrCreateRightNode(parentLeft);
            return parentRight.getChildNodes().item(XMLDiffUtils.getNodeIndex(left));
        }
        return null;
    }

    @Override
    protected void cleanUp(Node node) {
        this.insertRightBlocks(node);
        super.cleanUp(node);
    }

    private void insertRightBlocks(Node node) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = "//*[@data-xwiki-html-diff-block = 'deleted']";
        try {
            XMLDiffUtils.asList((NodeList)xpath.compile(expression).evaluate(node, XPathConstants.NODESET)).stream().forEach(this::insertRightBlock);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    private void insertRightBlock(Node leftBlock) {
        Element rightBlock = (Element)leftBlock.getUserData(RIGHT_BLOCK);
        if (rightBlock != null) {
            leftBlock.getParentNode().insertBefore(rightBlock, leftBlock.getNextSibling());
        }
    }
}

