/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.script;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.xml.XMLDiffMarker;
import org.xwiki.diff.xml.XMLDiffPruner;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;
import org.xwiki.xml.XMLUtils;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Named(value="diff.html")
@Singleton
@Unstable
public class DiffHTMLScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    private HTMLCleaner htmlCleaner;
    @Inject
    @Named(value="html")
    private XMLDiffMarker htmlDiffMarker;
    @Inject
    @Named(value="html")
    private XMLDiffPruner htmlDiffPruner;
    private DOMImplementationLS lsImpl;

    public DiffHTMLScriptService() {
        try {
            this.lsImpl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS 3.0"));
        }
        catch (Exception exception) {
            this.logger.warn("Cannot initialize the HTML Diff Script Service", (Throwable)exception);
        }
    }

    public String unified(String previousHTML, String nextHTML) {
        Document previousDocument = this.parseHTML(previousHTML);
        try {
            if (!this.htmlDiffMarker.markDiff((Node)previousDocument, (Node)this.parseHTML(nextHTML))) {
                return "";
            }
        }
        catch (DiffException e) {
            return null;
        }
        this.htmlDiffPruner.prune((Node)previousDocument);
        return this.unwrap(HTMLUtils.toString((Document)previousDocument, (boolean)false, (boolean)false).trim());
    }

    private Document parseHTML(String html) {
        return this.parseXML(this.cleanHTML(html));
    }

    private String cleanHTML(String html) {
        HTMLCleanerConfiguration config = this.htmlCleaner.getDefaultConfiguration();
        config.setParameters(Collections.singletonMap("useCharacterReferences", "true"));
        Document htmlDoc = this.htmlCleaner.clean((Reader)new StringReader(this.wrap(html)), config);
        return HTMLUtils.toString((Document)htmlDoc);
    }

    private Document parseXML(String xml) {
        LSInput input = this.lsImpl.createLSInput();
        input.setStringData(xml);
        return XMLUtils.parse((LSInput)input);
    }

    private String wrap(String fragment) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html><html xmlns=\"http://www.w3.org/1999/xhtml\"><head></head><body>" + fragment + "</body></html>";
    }

    private String unwrap(String html) {
        int start = html.indexOf("<body>") + 6;
        int end = html.indexOf("</body>");
        return html.substring(start, end);
    }
}

