/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.display.InlineDiffChunk;
import org.xwiki.diff.display.InlineDiffDisplayer;

@Component
@Singleton
public class DefaultInlineDiffDisplayer
implements InlineDiffDisplayer {
    @Override
    public <E> List<InlineDiffChunk<E>> display(DiffResult<E> diffResult) {
        int contextStart;
        List previous = diffResult.getPrevious();
        ArrayList chunks = new ArrayList();
        Delta lastDelta = null;
        Iterator iterator = diffResult.getPatch().iterator();
        while (iterator.hasNext()) {
            Delta delta;
            int contextEnd;
            int contextStart2 = lastDelta == null ? 0 : lastDelta.getPrevious().getLastIndex() + 1;
            if (contextStart2 < (contextEnd = (delta = (Delta)iterator.next()).getPrevious().getIndex())) {
                chunks.add(new InlineDiffChunk(InlineDiffChunk.Type.UNMODIFIED, previous.subList(contextStart2, contextEnd)));
            }
            switch (delta.getType()) {
                case CHANGE: {
                    chunks.add(new InlineDiffChunk(InlineDiffChunk.Type.DELETED, delta.getPrevious().getElements()));
                    chunks.add(new InlineDiffChunk(InlineDiffChunk.Type.ADDED, delta.getNext().getElements()));
                    break;
                }
                case DELETE: {
                    chunks.add(new InlineDiffChunk(InlineDiffChunk.Type.DELETED, delta.getPrevious().getElements()));
                    break;
                }
                case INSERT: {
                    chunks.add(new InlineDiffChunk(InlineDiffChunk.Type.ADDED, delta.getNext().getElements()));
                    break;
                }
            }
            lastDelta = delta;
        }
        int n = contextStart = lastDelta == null ? 0 : lastDelta.getPrevious().getLastIndex() + 1;
        if (contextStart < previous.size()) {
            chunks.add(new InlineDiffChunk(InlineDiffChunk.Type.UNMODIFIED, previous.subList(contextStart, previous.size())));
        }
        return chunks;
    }
}

