/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.display.InlineDiffChunk;
import org.xwiki.diff.display.InlineDiffDisplayer;
import org.xwiki.diff.display.UnifiedDiffBlock;
import org.xwiki.diff.display.UnifiedDiffConfiguration;
import org.xwiki.diff.display.UnifiedDiffDisplayer;
import org.xwiki.diff.display.UnifiedDiffElement;
import org.xwiki.diff.internal.DefaultChunk;
import org.xwiki.diff.internal.DeltaFactory;

@Component
@Singleton
public class DefaultUnifiedDiffDisplayer
implements UnifiedDiffDisplayer {
    @Inject
    private DiffManager diffManager;
    @Inject
    private InlineDiffDisplayer inlineDisplayer;

    @Override
    public <E, F> UnifiedDiffConfiguration<E, F> getDefaultConfiguration() {
        return new UnifiedDiffConfiguration();
    }

    @Override
    public <E, F> List<UnifiedDiffBlock<E, F>> display(DiffResult<E> diffResult) {
        return this.display(diffResult, this.getDefaultConfiguration());
    }

    @Override
    public <E, F> List<UnifiedDiffBlock<E, F>> display(DiffResult<E> diffResult, List<Conflict<E>> conflicts) {
        return this.display(diffResult, conflicts, this.getDefaultConfiguration());
    }

    @Override
    public <E, F> List<UnifiedDiffBlock<E, F>> display(DiffResult<E> diffResult, UnifiedDiffConfiguration<E, F> config) {
        return this.display(diffResult, null, config);
    }

    private <E> Conflict<E> findConflict(Delta<E> delta, List<Conflict<E>> conflicts) {
        if (conflicts != null) {
            for (Conflict<E> conflict : conflicts) {
                if (!conflict.concerns(delta)) continue;
                return conflict;
            }
        }
        return null;
    }

    private <E> List<Chunk<E>> splitChunk(Chunk<E> originalChunk, int conflictIndex, int conflictSize) {
        ArrayList<Chunk<DefaultChunk>> result = new ArrayList<Chunk<DefaultChunk>>();
        List elements = originalChunk.getElements();
        int index = originalChunk.getIndex();
        int listIndex = 0;
        if (index + conflictSize < conflictIndex) {
            return Collections.emptyList();
        }
        if (index < conflictIndex) {
            result.add((Chunk<DefaultChunk>)new DefaultChunk(index, elements.subList(0, conflictIndex - index)));
            index = conflictIndex;
            listIndex = conflictIndex;
        }
        int listLastIndex = Math.min(elements.size(), listIndex + conflictSize);
        result.add((Chunk<DefaultChunk>)new DefaultChunk(index, elements.subList(listIndex, listLastIndex)));
        index += conflictSize;
        listIndex = listLastIndex;
        if (listIndex < elements.size()) {
            result.add((Chunk<DefaultChunk>)new DefaultChunk(index, elements.subList(listIndex, elements.size())));
        }
        return result;
    }

    private <E> List<Delta<E>> splitDelta(Delta<E> delta, Conflict<E> conflict) {
        ArrayList<Delta<Delta>> result = new ArrayList<Delta<Delta>>();
        List<Chunk<E>> previousChunks = this.splitChunk(delta.getPrevious(), conflict.getIndex(), conflict.getMaxSize());
        List<Chunk<E>> nextChunks = this.splitChunk(delta.getNext(), conflict.getIndex(), conflict.getMaxSize());
        for (int i = 0; i < Math.max(previousChunks.size(), nextChunks.size()); ++i) {
            DefaultChunk previousChunk = i < previousChunks.size() ? previousChunks.get(i) : null;
            DefaultChunk nextChunk = i < nextChunks.size() ? nextChunks.get(i) : new DefaultChunk(previousChunk.getIndex(), Collections.emptyList());
            if (previousChunk == null) {
                previousChunk = new DefaultChunk(nextChunk.getIndex(), Collections.emptyList());
            }
            Delta.Type deltaType = previousChunk.getElements().isEmpty() ? Delta.Type.INSERT : (nextChunk.getElements().isEmpty() ? Delta.Type.DELETE : Delta.Type.CHANGE);
            result.add(DeltaFactory.createDelta((Chunk)previousChunk, (Chunk)nextChunk, (Delta.Type)deltaType));
        }
        return result;
    }

    private <E> Map<Delta<E>, Conflict<E>> buildDeltaConflictMap(List<Delta<E>> deltaList, List<Conflict<E>> conflicts) {
        LinkedHashMap<Delta<E>, Conflict<E>> result = new LinkedHashMap<Delta<E>, Conflict<E>>();
        for (Delta<E> delta : deltaList) {
            Conflict<E> conflict = this.findConflict(delta, conflicts);
            if (this.canDeltaSplitted(conflict, delta)) {
                List<Delta<E>> splittedDeltas = this.splitDelta(delta, conflict);
                result.putAll(this.buildDeltaConflictMap(splittedDeltas, conflicts));
                continue;
            }
            result.put(delta, conflict);
            if (conflicts == null || conflict == null) continue;
            conflicts.remove(conflict);
        }
        return result;
    }

    private <E> boolean canDeltaSplitted(Conflict<E> conflict, Delta<E> delta) {
        if (conflict != null) {
            boolean deltaCanBeSplitted = (delta.getPrevious().size() > 1 || delta.getNext().size() > 1) && conflict.getMaxSize() < delta.getMaxChunkSize();
            boolean conflictIsSubpartOfDelta = conflict.getMaxSize() != delta.getNext().size() || conflict.getMaxSize() != delta.getPrevious().size();
            return deltaCanBeSplitted && conflictIsSubpartOfDelta;
        }
        return false;
    }

    @Override
    public <E, F> List<UnifiedDiffBlock<E, F>> display(DiffResult<E> diffResult, List<Conflict<E>> conflicts, UnifiedDiffConfiguration<E, F> config) {
        State state = new State(diffResult.getPrevious());
        ArrayList<Conflict<E>> conflictList = null;
        if (conflicts != null) {
            conflictList = new ArrayList<Conflict<E>>(conflicts);
        }
        Map<Delta<E>, Conflict<E>> deltaAndConflicts = this.buildDeltaConflictMap((List<Delta<E>>)diffResult.getPatch(), (List<Conflict<E>>)conflictList);
        for (Delta<E> delta : deltaAndConflicts.keySet()) {
            Conflict<E> conflict = deltaAndConflicts.get(delta);
            this.maybeStartBlock(delta, state, config.getContextSize(), conflict);
            switch (delta.getType()) {
                case CHANGE: {
                    state.getBlocks().peek().addAll(this.getModifiedElements(delta, config));
                    break;
                }
                case DELETE: {
                    state.getBlocks().peek().addAll(this.getElements(delta.getPrevious(), UnifiedDiffElement.Type.DELETED));
                    break;
                }
                case INSERT: {
                    state.getBlocks().peek().addAll(this.getElements(delta.getNext(), UnifiedDiffElement.Type.ADDED));
                    break;
                }
            }
            state.setLastDelta(delta);
        }
        this.maybeEndBlock(state, config.getContextSize(), true);
        return state.getBlocks();
    }

    private <E, F> void maybeStartBlock(Delta<E> delta, State<E, F> state, int contextSize, Conflict<E> conflict) {
        if (state.getLastConflict() != conflict || state.getLastDelta() == null || state.getLastDelta().getPrevious().getLastIndex() < delta.getPrevious().getIndex() - contextSize * 2) {
            this.maybeEndBlock(state, contextSize, false);
            state.getBlocks().push(new UnifiedDiffBlock());
        }
        int count = state.getBlocks().peek().isEmpty() ? contextSize : contextSize * 2;
        int lastChangeIndex = state.getLastDelta() == null ? -1 : state.getLastDelta().getPrevious().getLastIndex();
        int end = delta.getPrevious().getIndex();
        int start = Math.max(end - count, lastChangeIndex + 1);
        state.getBlocks().peek().addAll(this.getUnmodifiedElements(state.getPrevious(), start, end));
        if (conflict != null && !state.getBlocks().peek().isEmpty()) {
            state.getBlocks().push(new UnifiedDiffBlock());
        }
        state.getBlocks().peek().setConflict(conflict);
        state.setLastConflict(conflict);
    }

    private <E, F> List<UnifiedDiffElement<E, F>> getModifiedElements(Delta<E> delta, UnifiedDiffConfiguration<E, F> config) {
        ArrayList<UnifiedDiffElement<UnifiedDiffElement<E, F>, F>> elements = new ArrayList<UnifiedDiffElement<UnifiedDiffElement<E, F>, F>>();
        elements.addAll(this.getElements(delta.getPrevious(), UnifiedDiffElement.Type.DELETED));
        elements.addAll(this.getElements(delta.getNext(), UnifiedDiffElement.Type.ADDED));
        if (config.getSplitter() != null && delta.getPrevious().size() == delta.getNext().size()) {
            int changeSize = delta.getPrevious().size();
            for (int i = 0; i < changeSize; ++i) {
                this.displayInlineDiff((UnifiedDiffElement)elements.get(i), (UnifiedDiffElement)elements.get(changeSize + i), config);
            }
        }
        return elements;
    }

    private <E, F> List<UnifiedDiffElement<E, F>> getElements(Chunk<E> chunk, UnifiedDiffElement.Type changeType) {
        int index = chunk.getIndex();
        ArrayList elements = new ArrayList();
        for (Object element : chunk.getElements()) {
            elements.add(new UnifiedDiffElement(index++, changeType, element));
        }
        return elements;
    }

    private <E, F> List<UnifiedDiffElement<E, F>> getUnmodifiedElements(List<E> previous, int start, int end) {
        ArrayList unmodifiedElements = new ArrayList();
        for (int i = start; i < end; ++i) {
            unmodifiedElements.add(new UnifiedDiffElement(i, UnifiedDiffElement.Type.CONTEXT, previous.get(i)));
        }
        return unmodifiedElements;
    }

    private <E, F> void maybeEndBlock(State<E, F> state, int contextSize, boolean lastBlock) {
        if (!state.getBlocks().isEmpty() && (state.getLastConflict() == null || lastBlock)) {
            int start = state.getLastDelta().getPrevious().getLastIndex() + 1;
            int end = Math.min(start + contextSize, state.getPrevious().size());
            List<UnifiedDiffElement<E, F>> unmodifiedElements = this.getUnmodifiedElements(state.getPrevious(), start, end);
            if (!unmodifiedElements.isEmpty() && state.getLastConflict() != null) {
                state.getBlocks().push(new UnifiedDiffBlock());
            }
            state.getBlocks().peek().addAll(unmodifiedElements);
        }
    }

    private <E, F> void displayInlineDiff(UnifiedDiffElement<E, F> previous, UnifiedDiffElement<E, F> next, UnifiedDiffConfiguration<E, F> config) {
        try {
            List<F> previousSubElements = config.getSplitter().split(previous.getValue());
            List<F> nextSubElements = config.getSplitter().split(next.getValue());
            DiffResult diffResult = this.diffManager.diff(previousSubElements, nextSubElements, config);
            List chunks = this.inlineDisplayer.display(diffResult);
            previous.setChunks(new ArrayList());
            next.setChunks(new ArrayList());
            for (InlineDiffChunk chunk : chunks) {
                if (!chunk.isAdded()) {
                    previous.getChunks().add(chunk);
                }
                if (chunk.isDeleted()) continue;
                next.getChunks().add(chunk);
            }
        }
        catch (DiffException diffException) {
            // empty catch block
        }
    }

    private static class State<E, F> {
        private final Stack<UnifiedDiffBlock<E, F>> blocks = new Stack();
        private final List<E> previous;
        private Delta<E> lastDelta;
        private Conflict<E> lastConflict;

        State(List<E> previous) {
            this.previous = previous;
        }

        public Delta<E> getLastDelta() {
            return this.lastDelta;
        }

        public void setLastDelta(Delta<E> lastDelta) {
            this.lastDelta = lastDelta;
        }

        public void setLastConflict(Conflict<E> lastConflict) {
            this.lastConflict = lastConflict;
        }

        public Conflict<E> getLastConflict() {
            return this.lastConflict;
        }

        public Stack<UnifiedDiffBlock<E, F>> getBlocks() {
            return this.blocks;
        }

        public List<E> getPrevious() {
            return this.previous;
        }
    }
}

