/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.display.InlineDiffChunk;
import org.xwiki.diff.display.InlineDiffDisplayer;
import org.xwiki.diff.display.UnifiedDiffBlock;
import org.xwiki.diff.display.UnifiedDiffConfiguration;
import org.xwiki.diff.display.UnifiedDiffDisplayer;
import org.xwiki.diff.display.UnifiedDiffElement;

@Component
@Singleton
public class DefaultUnifiedDiffDisplayer
implements UnifiedDiffDisplayer {
    @Inject
    private DiffManager diffManager;
    @Inject
    private InlineDiffDisplayer inlineDisplayer;

    @Override
    public <E, F> UnifiedDiffConfiguration<E, F> getDefaultConfiguration() {
        return new UnifiedDiffConfiguration();
    }

    @Override
    public <E, F> List<UnifiedDiffBlock<E, F>> display(DiffResult<E> diffResult) {
        return this.display(diffResult, this.getDefaultConfiguration());
    }

    @Override
    public <E, F> List<UnifiedDiffBlock<E, F>> display(DiffResult<E> diffResult, UnifiedDiffConfiguration<E, F> config) {
        State state = new State(diffResult.getPrevious());
        for (Delta delta : diffResult.getPatch()) {
            this.maybeStartBlock(delta, state, config.getContextSize());
            switch (delta.getType()) {
                case CHANGE: {
                    state.getBlocks().peek().addAll(this.getModifiedElements(delta, config));
                    break;
                }
                case DELETE: {
                    state.getBlocks().peek().addAll(this.getElements(delta.getPrevious(), UnifiedDiffElement.Type.DELETED));
                    break;
                }
                case INSERT: {
                    state.getBlocks().peek().addAll(this.getElements(delta.getNext(), UnifiedDiffElement.Type.ADDED));
                    break;
                }
            }
            state.setLastDelta(delta);
        }
        this.maybeEndBlock(state, config.getContextSize());
        return state.getBlocks();
    }

    private <E, F> void maybeStartBlock(Delta<E> delta, State<E, F> state, int contextSize) {
        if (state.getLastDelta() == null || state.getLastDelta().getPrevious().getLastIndex() < delta.getPrevious().getIndex() - contextSize * 2) {
            this.maybeEndBlock(state, contextSize);
            state.getBlocks().push(new UnifiedDiffBlock());
        }
        int count = state.getBlocks().peek().isEmpty() ? contextSize : contextSize * 2;
        int lastChangeIndex = state.getLastDelta() == null ? -1 : state.getLastDelta().getPrevious().getLastIndex();
        int end = delta.getPrevious().getIndex();
        int start = Math.max(end - count, lastChangeIndex + 1);
        state.getBlocks().peek().addAll(this.getUnmodifiedElements(state.getPrevious(), start, end));
    }

    private <E, F> List<UnifiedDiffElement<E, F>> getModifiedElements(Delta<E> delta, UnifiedDiffConfiguration<E, F> config) {
        ArrayList<UnifiedDiffElement<UnifiedDiffElement<E, F>, F>> elements = new ArrayList<UnifiedDiffElement<UnifiedDiffElement<E, F>, F>>();
        elements.addAll(this.getElements(delta.getPrevious(), UnifiedDiffElement.Type.DELETED));
        elements.addAll(this.getElements(delta.getNext(), UnifiedDiffElement.Type.ADDED));
        if (config.getSplitter() != null && delta.getPrevious().size() == delta.getNext().size()) {
            int changeSize = delta.getPrevious().size();
            for (int i = 0; i < changeSize; ++i) {
                this.displayInlineDiff((UnifiedDiffElement)elements.get(i), (UnifiedDiffElement)elements.get(changeSize + i), config);
            }
        }
        return elements;
    }

    private <E, F> List<UnifiedDiffElement<E, F>> getElements(Chunk<E> chunk, UnifiedDiffElement.Type changeType) {
        int index = chunk.getIndex();
        ArrayList elements = new ArrayList();
        for (Object element : chunk.getElements()) {
            elements.add(new UnifiedDiffElement(index++, changeType, element));
        }
        return elements;
    }

    private <E, F> List<UnifiedDiffElement<E, F>> getUnmodifiedElements(List<E> previous, int start, int end) {
        ArrayList unmodifiedElements = new ArrayList();
        for (int i = start; i < end; ++i) {
            unmodifiedElements.add(new UnifiedDiffElement(i, UnifiedDiffElement.Type.CONTEXT, previous.get(i)));
        }
        return unmodifiedElements;
    }

    private <E, F> void maybeEndBlock(State<E, F> state, int contextSize) {
        if (!state.getBlocks().isEmpty()) {
            int start = state.getLastDelta().getPrevious().getLastIndex() + 1;
            int end = Math.min(start + contextSize, state.getPrevious().size());
            state.getBlocks().peek().addAll(this.getUnmodifiedElements(state.getPrevious(), start, end));
        }
    }

    private <E, F> void displayInlineDiff(UnifiedDiffElement<E, F> previous, UnifiedDiffElement<E, F> next, UnifiedDiffConfiguration<E, F> config) {
        try {
            List<F> previousSubElements = config.getSplitter().split(previous.getValue());
            List<F> nextSubElements = config.getSplitter().split(next.getValue());
            DiffResult diffResult = this.diffManager.diff(previousSubElements, nextSubElements, config);
            List chunks = this.inlineDisplayer.display(diffResult);
            previous.setChunks(new ArrayList());
            next.setChunks(new ArrayList());
            for (InlineDiffChunk chunk : chunks) {
                if (!chunk.isAdded()) {
                    previous.getChunks().add(chunk);
                }
                if (chunk.isDeleted()) continue;
                next.getChunks().add(chunk);
            }
        }
        catch (DiffException diffException) {
            // empty catch block
        }
    }

    private static class State<E, F> {
        private final Stack<UnifiedDiffBlock<E, F>> blocks = new Stack();
        private final List<E> previous;
        private Delta<E> lastDelta;

        State(List<E> previous) {
            this.previous = previous;
        }

        public Delta<E> getLastDelta() {
            return this.lastDelta;
        }

        public void setLastDelta(Delta<E> lastDelta) {
            this.lastDelta = lastDelta;
        }

        public Stack<UnifiedDiffBlock<E, F>> getBlocks() {
            return this.blocks;
        }

        public List<E> getPrevious() {
            return this.previous;
        }
    }
}

