/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.filesystem.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.store.FileStoreReference;
import org.xwiki.crypto.store.StoreReference;

public abstract class AbstractX509FileSystemStore {
    protected static final String CERTIFICATE = "CERTIFICATE";
    protected static final String DASHES = "-----";
    protected static final String PEM_BEGIN = "-----BEGIN ";
    protected static final String PEM_END = "-----END ";
    protected static final String KEY_FILE_EXTENSION = ".key";
    protected static final String CERTIFICATE_FILE_EXTENSION = ".cert";
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64;
    @Inject
    @Named(value="X509")
    private CertificateFactory certificateFactory;

    protected void store(BufferedWriter out, String type, byte[] data) throws IOException {
        this.write(out, type, data);
        out.close();
    }

    protected void write(BufferedWriter out, String type, byte[] data) throws IOException {
        AbstractX509FileSystemStore.writeHeader(out, type);
        out.write(this.base64.encode(data, 64));
        out.newLine();
        AbstractX509FileSystemStore.writeFooter(out, type);
    }

    private static void writeHeader(BufferedWriter out, String type) throws IOException {
        out.write(PEM_BEGIN + type + DASHES);
        out.newLine();
    }

    private static void writeFooter(BufferedWriter out, String type) throws IOException {
        out.write(PEM_END + type + DASHES);
        out.newLine();
    }

    protected File getStoreFile(StoreReference store) {
        if (store instanceof FileStoreReference) {
            return ((FileStoreReference)store).getFile();
        }
        throw new IllegalArgumentException(String.format("Unsupported store reference [%s] for this implementation.", store.getClass().getName()));
    }

    protected boolean isMulti(StoreReference store) {
        return !(store instanceof FileStoreReference) || ((FileStoreReference)store).isMulti();
    }

    protected X509CertifiedPublicKey getPublicKey(CertifiedPublicKey publicKey) {
        if (publicKey instanceof X509CertifiedPublicKey) {
            return (X509CertifiedPublicKey)publicKey;
        }
        throw new IllegalArgumentException(String.format("Unsupported certificate [%s], expecting X509 certificates.", publicKey.getClass().getName()));
    }

    protected String getCertIdentifier(X509CertifiedPublicKey publicKey) throws IOException {
        byte[] keyId = publicKey.getSubjectKeyIdentifier();
        if (keyId != null) {
            return this.base64.encode(keyId);
        }
        return publicKey.getSerialNumber().toString() + ", " + publicKey.getIssuer().getName();
    }

    protected Object readObject(BufferedReader in, byte[] password) throws IOException, GeneralSecurityException {
        String line;
        Object obj = null;
        while ((line = in.readLine()) != null && (obj = this.processObject(in, line, password)) == null) {
        }
        return obj;
    }

    protected Object processObject(BufferedReader in, String line, byte[] password) throws IOException, GeneralSecurityException {
        if (line.contains("-----BEGIN CERTIFICATE-----")) {
            return this.certificateFactory.decode(this.readBytes(in, "-----END CERTIFICATE-----"));
        }
        return null;
    }

    protected byte[] readBytes(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null && !line.contains(endMarker)) {
            buf.append(line.trim());
        }
        return this.base64.decode(buf.toString());
    }
}

