/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.filesystem.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.params.cipher.asymmetric.PrivateKeyParameters;
import org.xwiki.crypto.password.PrivateKeyPasswordBasedEncryptor;
import org.xwiki.crypto.pkix.params.CertifiedKeyPair;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.store.KeyStore;
import org.xwiki.crypto.store.KeyStoreException;
import org.xwiki.crypto.store.StoreReference;
import org.xwiki.crypto.store.filesystem.internal.AbstractX509FileSystemStore;

@Component
@Named(value="X509file")
@Singleton
public class X509KeyFileSystemStore
extends AbstractX509FileSystemStore
implements KeyStore {
    private static final String PRIVATE_KEY = "PRIVATE KEY";
    private static final String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
    @Inject
    private PrivateKeyPasswordBasedEncryptor encryptor;
    @Inject
    private AsymmetricKeyFactory keyFactory;

    public void store(StoreReference store, CertifiedKeyPair keyPair) throws KeyStoreException {
        this.storeKeyPair(store, this.getPublicKey(keyPair.getCertificate()), keyPair.getPrivateKey().getEncoded(), PRIVATE_KEY);
    }

    public void store(StoreReference store, CertifiedKeyPair keyPair, byte[] password) throws KeyStoreException {
        byte[] key;
        try {
            key = this.encryptor.encrypt(password, keyPair.getPrivateKey());
        }
        catch (Exception e) {
            throw new KeyStoreException(String.format("Error while encrypting private key to store a key pair in [%s]", store), (Throwable)e);
        }
        this.storeKeyPair(store, this.getPublicKey(keyPair.getCertificate()), key, ENCRYPTED_PRIVATE_KEY);
    }

    private void storeKeyPair(StoreReference store, X509CertifiedPublicKey certificate, byte[] privateKey, String type) throws KeyStoreException {
        File file = this.getStoreFile(store);
        try {
            if (this.isMulti(store)) {
                if (!file.exists() && !file.mkdirs()) {
                    throw new KeyStoreException(String.format("Error while creating path [%s]", file));
                }
                String filename = this.getCertIdentifier(certificate);
                File keyfile = new File(file, filename + ".key");
                File certfile = new File(file, filename + ".cert");
                this.store(new BufferedWriter(new FileWriter(keyfile)), type, privateKey);
                byte[] encodedCertificate = certificate.getEncoded();
                this.store(new BufferedWriter(new FileWriter(certfile)), "CERTIFICATE", encodedCertificate);
            } else {
                if (!file.exists() && !file.createNewFile()) {
                    throw new KeyStoreException(String.format("Error while creating file [%s]", file));
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                this.write(out, type, privateKey);
                this.store(out, "CERTIFICATE", certificate.getEncoded());
            }
        }
        catch (IOException e) {
            throw new KeyStoreException(String.format("Error while writing private key to file [%s]", file), (Throwable)e);
        }
    }

    public CertifiedKeyPair retrieve(StoreReference store) throws KeyStoreException {
        return this.retrieve(store, (byte[])null);
    }

    public CertifiedKeyPair retrieve(StoreReference store, byte[] password) throws KeyStoreException {
        File file = this.getStoreFile(store);
        if (this.isMulti(store)) {
            throw new KeyStoreException(String.format("Unexpected store reference, [%s] should be single key store.", file));
        }
        X509CertifiedPublicKey cert = null;
        PrivateKeyParameters key = null;
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            Object obj;
            while ((obj = this.readObject(in, password)) != null) {
                if (obj instanceof X509CertifiedPublicKey) {
                    cert = (X509CertifiedPublicKey)obj;
                    continue;
                }
                if (!(obj instanceof PrivateKeyParameters)) continue;
                key = (PrivateKeyParameters)obj;
            }
        }
        catch (IOException e) {
            throw new KeyStoreException(String.format("Error while reading from file [%s]", file), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(String.format("Error while decrypting private key from file [%s]", file), (Throwable)e);
        }
        if (key != null && cert != null) {
            return new CertifiedKeyPair(key, (CertifiedPublicKey)cert);
        }
        return null;
    }

    public CertifiedKeyPair retrieve(StoreReference store, CertifiedPublicKey publicKey) throws KeyStoreException {
        return this.retrieve(store, publicKey, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CertifiedKeyPair retrieve(StoreReference store, CertifiedPublicKey publicKey, byte[] password) throws KeyStoreException {
        File file = this.getStoreFile(store);
        X509CertifiedPublicKey certificate = this.getPublicKey(publicKey);
        if (!this.isMulti(store)) {
            throw new KeyStoreException(String.format("Unexpected store reference, [%s] should be multi key store.", file));
        }
        try {
            File keyfile = new File(file, this.getCertIdentifier(certificate) + ".key");
            if (!keyfile.exists()) return null;
            try (BufferedReader in = new BufferedReader(new FileReader(keyfile));){
                Object obj;
                do {
                    if ((obj = this.readObject(in, password)) == null) return null;
                } while (!(obj instanceof PrivateKeyParameters));
                CertifiedKeyPair certifiedKeyPair = new CertifiedKeyPair((PrivateKeyParameters)obj, (CertifiedPublicKey)certificate);
                return certifiedKeyPair;
            }
        }
        catch (IOException e) {
            throw new KeyStoreException(String.format("Error while reading private key from store [%s]", file), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(String.format("Error while decrypting private key from store [%s]", file), (Throwable)e);
        }
    }

    @Override
    protected Object processObject(BufferedReader in, String line, byte[] password) throws IOException, GeneralSecurityException {
        if (line.contains("-----BEGIN PRIVATE KEY-----")) {
            return this.keyFactory.fromPKCS8(this.readBytes(in, "-----END PRIVATE KEY-----"));
        }
        if (line.contains("-----BEGIN ENCRYPTED PRIVATE KEY-----")) {
            return this.encryptor.decrypt(password, this.readBytes(in, "-----END ENCRYPTED PRIVATE KEY-----"));
        }
        return super.processObject(in, line, password);
    }
}

