/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.factory;

import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;
import org.xwiki.crypto.signer.internal.factory.AbstractBcSignerFactory;

@Component(hints={"DSAwithSHA1", "1.2.840.10040.4.3"})
@Singleton
public class BcDSAwithSHA1SignerFactory
extends AbstractBcSignerFactory {
    private static final AlgorithmIdentifier ALG_ID = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa_with_sha1, (ASN1Encodable)DERNull.INSTANCE);

    @Override
    protected Signer getSignerInstance(AsymmetricCipherParameters parameters) {
        return new DSADigestSigner((DSA)new DSASigner(), (Digest)new SHA1Digest());
    }

    @Override
    protected AlgorithmIdentifier getSignerAlgorithmIdentifier(AsymmetricCipherParameters parameters) {
        return ALG_ID;
    }
}

