/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.factory;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;
import org.xwiki.crypto.signer.internal.factory.AbstractSignerFactory;
import org.xwiki.crypto.signer.internal.factory.BcSignerFactory;

@Component
@Singleton
public class DefaultSignerFactory
extends AbstractSignerFactory
implements BcSignerFactory {
    @Inject
    private ComponentManager manager;

    @Override
    public Signer getInstance(boolean forSigning, CipherParameters parameters) {
        throw new UnsupportedOperationException("This signer does not support to be created from cipher parameters");
    }

    @Override
    public Signer getInstance(boolean forSigning, CipherParameters parameters, byte[] encoded) {
        return this.getInstance(forSigning, parameters, AlgorithmIdentifier.getInstance((Object)encoded));
    }

    @Override
    public Signer getInstance(boolean forSigning, CipherParameters parameters, AlgorithmIdentifier algId) {
        SignerFactory factory = this.getFactory(algId.getAlgorithm().getId());
        if (factory instanceof BcSignerFactory) {
            return ((BcSignerFactory)((Object)factory)).getInstance(forSigning, parameters, algId);
        }
        try {
            return factory.getInstance(forSigning, parameters, algId.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to encode algorithm identifier.");
        }
    }

    protected SignerFactory getFactory(String hint) {
        try {
            return (SignerFactory)this.manager.getInstance(SignerFactory.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Signing algorithm not found.", e);
        }
    }
}

