/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.xwiki.crypto.internal.asymmetric.BcPublicKeyParameters;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.internal.extension.BcX509Extensions;
import org.xwiki.crypto.pkix.params.x509certificate.DistinguishedName;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;
import org.xwiki.crypto.signer.internal.factory.BcSignerFactory;

public class BcX509CertifiedPublicKey
implements X509CertifiedPublicKey {
    private final X509CertificateHolder holder;
    private final SignerFactory signerFactory;

    BcX509CertifiedPublicKey(X509CertificateHolder holder, SignerFactory signerFactory) {
        this.holder = holder;
        this.signerFactory = signerFactory;
    }

    public X509CertificateHolder getX509CertificateHolder() {
        return this.holder;
    }

    @Override
    public DistinguishedName getIssuer() {
        return new DistinguishedName(this.holder.getIssuer());
    }

    @Override
    public DistinguishedName getSubject() {
        return new DistinguishedName(this.holder.getSubject());
    }

    @Override
    public Date getNotAfter() {
        return this.holder.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.holder.getNotBefore();
    }

    @Override
    public int getVersionNumber() {
        return this.holder.getVersionNumber();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.holder.getSerialNumber();
    }

    @Override
    public boolean isValidOn(Date date) {
        return this.holder.isValidOn(date);
    }

    @Override
    public boolean isRootCA() {
        X509Extensions exts = this.getExtensions();
        if (exts != null) {
            return exts.hasCertificateAuthorityBasicConstraints() && this.isSelfSigned();
        }
        return this.isSelfSigned();
    }

    @Override
    public X509Extensions getExtensions() {
        Extensions extensions = this.holder.getExtensions();
        return extensions != null ? new BcX509Extensions(extensions) : null;
    }

    @Override
    public byte[] getAuthorityKeyIdentifier() {
        X509Extensions exts = this.getExtensions();
        if (exts == null) {
            return null;
        }
        return exts.getAuthorityKeyIdentifier();
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        X509Extensions exts = this.getExtensions();
        if (exts == null) {
            return null;
        }
        return exts.getSubjectKeyIdentifier();
    }

    @Override
    public PublicKeyParameters getPublicKeyParameters() {
        try {
            return new BcPublicKeyParameters(PublicKeyFactory.createKey((SubjectPublicKeyInfo)this.holder.getSubjectPublicKeyInfo()));
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Unsupported public key encoding.", e);
        }
    }

    @Override
    public boolean isSignedBy(PublicKeyParameters publicKey) throws GeneralSecurityException {
        TBSCertificate tbsCert = this.holder.toASN1Structure().getTBSCertificate();
        if (!BcUtils.isAlgorithlIdentifierEqual(tbsCert.getSignature(), this.holder.getSignatureAlgorithm())) {
            return false;
        }
        Signer signer = null;
        if (this.signerFactory instanceof BcSignerFactory) {
            signer = ((BcSignerFactory)this.signerFactory).getInstance(false, (CipherParameters)publicKey, tbsCert.getSignature());
        } else {
            try {
                signer = this.signerFactory.getInstance(false, (CipherParameters)publicKey, this.holder.getSignatureAlgorithm().getEncoded());
            }
            catch (IOException e) {
                return false;
            }
        }
        try {
            return BcUtils.updateDEREncodedObject(signer, (ASN1Encodable)tbsCert).verify(this.holder.getSignature());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isSelfSigned() {
        X509Extensions exts = this.getExtensions();
        if (exts != null) {
            byte[] issuerId = exts.getAuthorityKeyIdentifier();
            byte[] subjectId = exts.getSubjectKeyIdentifier();
            if (issuerId != null) {
                return Arrays.equals(issuerId, subjectId);
            }
        }
        return this.getIssuer().equals(this.getSubject());
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.holder.getEncoded();
    }

    public boolean equals(Object cert) {
        byte[] thatId;
        if (this == cert) {
            return true;
        }
        if (cert == null || !(cert instanceof X509CertifiedPublicKey)) {
            return false;
        }
        X509CertifiedPublicKey that = (X509CertifiedPublicKey)cert;
        X509Extensions thisExts = this.getExtensions();
        X509Extensions thatExts = that.getExtensions();
        byte[] thisId = thisExts != null ? thisExts.getSubjectKeyIdentifier() : null;
        byte[] byArray = thatId = thatExts != null ? thatExts.getSubjectKeyIdentifier() : null;
        if (thisId != null) {
            return Arrays.equals(thisId, thatId);
        }
        if (thatExts != null) {
            return false;
        }
        return this.getIssuer().equals(that.getIssuer()) && this.getSerialNumber().equals(that.getSerialNumber());
    }

    public int hashCode() {
        byte[] id;
        X509Extensions exts = this.getExtensions();
        if (exts != null && (id = exts.getSubjectKeyIdentifier()) != null) {
            return Arrays.hashCode(id);
        }
        return new HashCodeBuilder(3, 17).append((Object)this.getIssuer()).append((Object)this.getSerialNumber()).toHashCode();
    }
}

