/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.operator.ContentSigner;
import org.xwiki.crypto.internal.asymmetric.BcAsymmetricKeyParameters;
import org.xwiki.crypto.internal.asymmetric.BcPublicKeyParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.internal.BcPrincipalIdentifier;
import org.xwiki.crypto.pkix.internal.BcX509CertificateFactory;
import org.xwiki.crypto.pkix.internal.BcX509CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.signer.Signer;

public final class BcUtils {
    private BcUtils() {
    }

    public static X509CertificateHolder getX509CertificateHolder(CertifiedPublicKey cert) {
        if (cert instanceof BcX509CertifiedPublicKey) {
            return ((BcX509CertifiedPublicKey)cert).getX509CertificateHolder();
        }
        try {
            return new X509CertificateHolder(cert.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid certified public key, unable to encode.");
        }
    }

    public static AsymmetricKeyParameter getAsymmetricKeyParameter(PublicKeyParameters publicKey) {
        if (publicKey instanceof BcAsymmetricKeyParameters) {
            return ((BcAsymmetricKeyParameters)publicKey).getParameters();
        }
        try {
            return PublicKeyFactory.createKey((byte[])publicKey.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid public key, unable to encode.");
        }
    }

    public static SubjectPublicKeyInfo getSubjectPublicKeyInfo(PublicKeyParameters publicKey) {
        try {
            if (publicKey instanceof BcPublicKeyParameters) {
                return ((BcPublicKeyParameters)publicKey).getSubjectPublicKeyInfo();
            }
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)BcUtils.getAsymmetricKeyParameter(publicKey));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid public key, unable to get subject info.");
        }
    }

    public static X509CertificateHolder getX509CertificateHolder(TBSCertificate tbsCert, byte[] signature) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)tbsCert);
        v.add((ASN1Encodable)tbsCert.getSignature());
        v.add((ASN1Encodable)new DERBitString(signature));
        return new X509CertificateHolder(Certificate.getInstance((Object)new DERSequence(v)));
    }

    public static boolean isAlgorithlIdentifierEqual(AlgorithmIdentifier id1, AlgorithmIdentifier id2) {
        if (!id1.getAlgorithm().equals((Object)id2.getAlgorithm())) {
            return false;
        }
        if (id1.getParameters() == null) {
            return id2.getParameters() == null || id2.getParameters().equals(DERNull.INSTANCE);
        }
        if (id2.getParameters() == null) {
            return id1.getParameters() == null || id1.getParameters().equals(DERNull.INSTANCE);
        }
        return id1.getParameters().equals(id2.getParameters());
    }

    public static Signer updateDEREncodedObject(Signer signer, ASN1Encodable tbsObj) throws IOException {
        OutputStream sOut = signer.getOutputStream();
        DEROutputStream dOut = new DEROutputStream(sOut);
        dOut.writeObject(tbsObj);
        sOut.close();
        return signer;
    }

    public static X500Name getX500Name(PrincipalIndentifier principal) {
        if (principal instanceof BcPrincipalIdentifier) {
            return ((BcPrincipalIdentifier)((Object)principal)).getX500Name();
        }
        return new X500Name(principal.getName());
    }

    public static AlgorithmIdentifier getSignerAlgoritmIdentifier(Signer signer) {
        if (signer instanceof ContentSigner) {
            return ((ContentSigner)signer).getAlgorithmIdentifier();
        }
        return AlgorithmIdentifier.getInstance((Object)signer.getEncoded());
    }

    public static CertifiedPublicKey convertCertificate(CertificateFactory certFactory, X509CertificateHolder cert) {
        if (cert == null) {
            return null;
        }
        if (certFactory instanceof BcX509CertificateFactory) {
            return ((BcX509CertificateFactory)certFactory).convert(cert);
        }
        try {
            return certFactory.decode(cert.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid Certificate, unable to encode", e);
        }
    }
}

