/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.bouncycastle.cert.AttributeCertificateHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;

@Component
@Named(value="BCStoreX509")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class BcStoreX509CertificateProvider
implements CertificateProvider {
    @Inject
    @Named(value="X509")
    private CertificateFactory factory;
    private Store store;

    public void setStore(Store store) {
        this.store = store;
    }

    public X509CertificateHolder getCertificate(Selector selector) {
        try {
            return (X509CertificateHolder)this.store.getMatches(selector).iterator().next();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public CertifiedPublicKey getCertificate(byte[] keyIdentifier) {
        return BcUtils.convertCertificate(this.factory, this.getCertificate((Selector)new SignerId(keyIdentifier)));
    }

    @Override
    public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial) {
        return BcUtils.convertCertificate(this.factory, this.getCertificate((Selector)new SignerId(BcUtils.getX500Name(issuer), serial)));
    }

    @Override
    public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial, byte[] keyIdentifier) {
        return BcUtils.convertCertificate(this.factory, this.getCertificate((Selector)new SignerId(BcUtils.getX500Name(issuer), serial, keyIdentifier)));
    }

    @Override
    public Collection<CertifiedPublicKey> getCertificate(PrincipalIndentifier subject) {
        AttributeCertificateHolder selector = new AttributeCertificateHolder(BcUtils.getX500Name(subject));
        try {
            Collection matches = this.store.getMatches((Selector)selector);
            ArrayList<CertifiedPublicKey> result = new ArrayList<CertifiedPublicKey>(matches.size());
            for (Object holder : matches) {
                if (!(holder instanceof X509CertificateHolder)) continue;
                result.add(BcUtils.convertCertificate(this.factory, (X509CertificateHolder)holder));
            }
            return !result.isEmpty() ? result : null;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

