/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;
import org.xwiki.crypto.signer.internal.BcContentVerifierProviderBuilder;
import org.xwiki.crypto.signer.internal.factory.BcSignerFactory;

@Component
@Singleton
public class DefaultBcContentVerifierProviderBuilder
implements BcContentVerifierProviderBuilder {
    @Inject
    private ComponentManager manager;

    @Override
    public ContentVerifierProvider build(final CertifiedPublicKey certificate) {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return true;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return BcUtils.getX509CertificateHolder(certificate);
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) {
                return DefaultBcContentVerifierProviderBuilder.this.getInstance((CipherParameters)certificate.getPublicKeyParameters(), algorithm);
            }
        };
    }

    @Override
    public ContentVerifierProvider build(final PublicKeyParameters publicKey) {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return false;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) {
                return DefaultBcContentVerifierProviderBuilder.this.getInstance((CipherParameters)publicKey, algorithm);
            }
        };
    }

    private ContentVerifier getInstance(CipherParameters parameters, final AlgorithmIdentifier algId) {
        Signer signer;
        SignerFactory factory = this.getFactory(algId.getAlgorithm().getId());
        if (factory instanceof BcSignerFactory) {
            return (ContentVerifier)((BcSignerFactory)factory).getInstance(false, parameters, algId);
        }
        try {
            signer = factory.getInstance(false, parameters, algId.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to encode algorithm identifier.");
        }
        return new ContentVerifier(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algId;
            }

            public OutputStream getOutputStream() {
                return signer.getOutputStream();
            }

            public boolean verify(byte[] bytes) {
                return DefaultBcContentVerifierProviderBuilder.verify(signer, bytes);
            }
        };
    }

    private static boolean verify(Signer signer, byte[] bytes) {
        try {
            return signer.verify(bytes);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    protected SignerFactory getFactory(String hint) {
        try {
            return (SignerFactory)this.manager.getInstance(SignerFactory.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Signing algorithm not found.", e);
        }
    }
}

