/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal.extension;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.xwiki.crypto.pkix.internal.extension.BcGeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.ExtendedKeyUsages;
import org.xwiki.crypto.pkix.params.x509certificate.extension.KeyUsage;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509DirectoryName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509DnsName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509GeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509GenericName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509IpAddress;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Rfc822Name;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509URI;

public final class BcExtensionUtils {
    private BcExtensionUtils() {
    }

    public static List<X509GeneralName> getX509GeneralNames(GeneralNames genNames) {
        if (genNames == null) {
            return null;
        }
        GeneralName[] names = genNames.getNames();
        ArrayList<X509GeneralName> x509names = new ArrayList<X509GeneralName>(names.length);
        block7: for (GeneralName name : names) {
            switch (name.getTagNo()) {
                case 1: {
                    x509names.add(new X509Rfc822Name(name));
                    continue block7;
                }
                case 2: {
                    x509names.add(new X509DnsName(name));
                    continue block7;
                }
                case 4: {
                    x509names.add(new X509DirectoryName(name));
                    continue block7;
                }
                case 6: {
                    x509names.add(new X509URI(name));
                    continue block7;
                }
                case 7: {
                    x509names.add(new X509IpAddress(name));
                    continue block7;
                }
                default: {
                    x509names.add(new X509GenericName(name));
                }
            }
        }
        return x509names;
    }

    public static EnumSet<KeyUsage> getSetOfKeyUsage(org.bouncycastle.asn1.x509.KeyUsage keyUsage) {
        if (keyUsage == null) {
            return null;
        }
        ArrayList<KeyUsage> usages = new ArrayList<KeyUsage>();
        for (KeyUsage usage : KeyUsage.values()) {
            if ((((DERBitString)keyUsage.toASN1Primitive()).intValue() & usage.value()) <= 0) continue;
            usages.add(usage);
        }
        return EnumSet.copyOf(usages);
    }

    public static ExtendedKeyUsages getExtendedKeyUsages(ExtendedKeyUsage usages) {
        if (usages == null) {
            return null;
        }
        ArrayList<String> usageStr = new ArrayList<String>();
        for (KeyPurposeId keyPurposeId : usages.getUsages()) {
            usageStr.add(keyPurposeId.getId());
        }
        return new ExtendedKeyUsages(usageStr);
    }

    public static GeneralNames getGeneralNames(X509GeneralName[] genNames) {
        GeneralName[] names = new GeneralName[genNames.length];
        int i = 0;
        for (X509GeneralName name : genNames) {
            if (!(name instanceof BcGeneralName)) {
                throw new IllegalArgumentException("Unexpected general name: " + name.getClass().toString());
            }
            names[i++] = ((BcGeneralName)((Object)name)).getGeneralName();
        }
        return new GeneralNames(names);
    }

    public static org.bouncycastle.asn1.x509.KeyUsage getKeyUsage(EnumSet<KeyUsage> usages) {
        int bitmask = 0;
        for (KeyUsage usage : usages) {
            bitmask |= usage.value();
        }
        return new org.bouncycastle.asn1.x509.KeyUsage(bitmask);
    }

    public static ExtendedKeyUsage getExtendedKeyUsage(Set<String> usages) {
        KeyPurposeId[] keyUsages = new KeyPurposeId[usages.size()];
        int i = 0;
        for (String usage : usages) {
            keyUsages[i++] = KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(usage));
        }
        return new ExtendedKeyUsage(keyUsages);
    }
}

