/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal.extension;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.xwiki.crypto.pkix.X509ExtensionBuilder;
import org.xwiki.crypto.pkix.internal.extension.BcX509Extensions;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;

public abstract class AbstractBcX509ExtensionBuilder
implements X509ExtensionBuilder {
    private final ExtensionsGenerator extensions = new ExtensionsGenerator();

    @Override
    public X509ExtensionBuilder addExtension(String oid, boolean critical, byte[] value) throws IOException {
        this.extensions.addExtension(new ASN1ObjectIdentifier(oid), critical, value);
        return this;
    }

    @Override
    public X509ExtensionBuilder addExtensions(X509Extensions extensionSet) throws IOException {
        if (extensionSet == null) {
            return this;
        }
        if (extensionSet instanceof BcX509Extensions) {
            Extensions exts = ((BcX509Extensions)extensionSet).getExtensions();
            Enumeration oids = exts.oids();
            while (oids.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)oids.nextElement();
                Extension ext = exts.getExtension(oid);
                this.extensions.addExtension(ext.getExtnId(), ext.isCritical(), ext.getParsedValue());
            }
        } else {
            for (String oid : extensionSet.getExtensionOID()) {
                this.extensions.addExtension(new ASN1ObjectIdentifier(oid), extensionSet.isCritical(oid), extensionSet.getExtensionValue(oid));
            }
        }
        return this;
    }

    public X509ExtensionBuilder addExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1Encodable value) {
        try {
            this.extensions.addExtension(oid, critical, value.toASN1Primitive().getEncoded("DER"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid extension value, it could not be properly DER encoded.");
        }
        return this;
    }

    @Override
    public X509Extensions build() {
        if (this.extensions.isEmpty()) {
            return null;
        }
        return new BcX509Extensions(this.extensions.generate());
    }

    @Override
    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }
}

